/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.clover.impl.graphprovider;

import com.mulesoft.mule.module.datamapper.api.GraphProvider;
import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.clover.api.CloverGraphFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetel.graph.TransformationGraph;

public class RecycleSingleGraphProvider
implements GraphProvider<TransformationGraph> {
    private static Log logger = LogFactory.getLog(RecycleSingleGraphProvider.class);
    private TransformationGraph transformationGraph;
    private CloverGraphFactory graphFactory;

    public static RecycleSingleGraphProvider createGraphProvider(CloverGraphFactory cloverGraphFactory) throws DataMapperCreationException {
        return new RecycleSingleGraphProvider(cloverGraphFactory);
    }

    private RecycleSingleGraphProvider(CloverGraphFactory graphFactory) throws DataMapperCreationException {
        this.graphFactory = graphFactory;
        this.transformationGraph = this.newTransformationGraph();
    }

    @Override
    public TransformationGraph takeGraph() {
        if (!this.transformationGraph.isInitialized()) {
            try {
                this.transformationGraph.init();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.transformationGraph;
    }

    private TransformationGraph newTransformationGraph() throws DataMapperCreationException {
        return this.graphFactory.createTransformationGraph();
    }

    @Override
    public void releaseGraph(TransformationGraph transformationGraph) {
        try {
            transformationGraph.postExecute();
            transformationGraph.preExecute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void invalidateObject(TransformationGraph transformationGraph) {
        transformationGraph.free();
        this.takeGraph();
    }
}

