/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.clover.impl.graphprovider;

import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.clover.api.CloverGraphFactory;
import java.util.Set;
import org.apache.commons.pool.PoolableObjectFactory;
import org.jetel.graph.TransformationGraph;

public class CloverGraphPoolFactory
implements PoolableObjectFactory {
    protected CloverGraphFactory graphFactory;

    public CloverGraphPoolFactory(CloverGraphFactory graphFactory) {
        this.graphFactory = graphFactory;
    }

    protected TransformationGraph createTransformationGraph() throws DataMapperCreationException {
        return this.getGraphFactory().createTransformationGraph();
    }

    public void passivateObject(Object obj) throws Exception {
        TransformationGraph graph = (TransformationGraph)obj;
        Set keys = graph.getDictionary().getKeys();
        for (String key : keys) {
            graph.getDictionary().setValue(key, null);
        }
        graph.postExecute();
    }

    public void destroyObject(Object obj) throws Exception {
        TransformationGraph graph = (TransformationGraph)obj;
        graph.free();
    }

    public void activateObject(Object obj) throws Exception {
        TransformationGraph graph = (TransformationGraph)obj;
        graph.preExecute();
    }

    public boolean validateObject(Object obj) {
        if (obj == null) {
            return false;
        }
        TransformationGraph graph = (TransformationGraph)obj;
        return graph.isInitialized() && graph.isChecked();
    }

    public Object makeObject() throws Exception {
        return this.createTransformationGraph();
    }

    public CloverGraphFactory getGraphFactory() {
        return this.graphFactory;
    }

    public void setGraphFactory(CloverGraphFactory graphFactory) {
        this.graphFactory = graphFactory;
    }
}

