/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.clover.impl;

import com.mulesoft.mule.module.datamapper.clover.api.GraphRuntimeContextFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Level;
import org.jetel.graph.runtime.ExecutionType;
import org.jetel.graph.runtime.GraphRuntimeContext;
import org.jetel.graph.runtime.IAuthorityProxy;
import org.jetel.graph.runtime.PrimitiveAuthorityProxy;

public class GraphRuntimeContextFactoryImpl
implements GraphRuntimeContextFactory {
    private static final String configResource = "clover-graph-runtime-config.properties";
    public static final String DATAMAPPER_DEBUG_MODE = "datamapper.debugMode";
    public static final String DATAMAPPER_DEBUG_DIRECTORY = "datamapper.debugDirectory";
    public static final String DATAMAPPER_USE_JMX = "datamapper.useJMX";
    private Properties properties;
    private static IAuthorityProxy authorityProxy = new PrimitiveAuthorityProxy();
    private final List<String> propertyNames = Arrays.asList("trackingInterval", "skipCheckConfig", "verboseMode", "useJMX", "waitForJMXClient", "password", "debugMode", "debugDirectory", "runtimeClassPath", "compileClassPath", "synchronizedRun", "transactionMode", "batchMode", "contextURL");
    private ExecutionType executionType;
    private ClassLoader classLoader;

    public GraphRuntimeContextFactoryImpl(ExecutionType executionType) {
        this(executionType, Thread.currentThread().getContextClassLoader());
    }

    public GraphRuntimeContextFactoryImpl(ExecutionType executionType, ClassLoader classLoader) {
        this.executionType = executionType;
        this.classLoader = classLoader;
        this.properties = new Properties();
        URL propertiesUrl = classLoader.getResource(configResource);
        if (propertiesUrl != null) {
            try {
                this.properties.load(propertiesUrl.openStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.loadFromSysProps();
    }

    private void loadFromSysProps() {
        if (Boolean.getBoolean(DATAMAPPER_DEBUG_MODE)) {
            this.properties.setProperty("debugMode", "true");
        } else {
            this.properties.setProperty("debugMode", "false");
        }
        if (System.getProperty(DATAMAPPER_DEBUG_DIRECTORY) != null) {
            this.properties.setProperty("debugDirectory", System.getProperty(DATAMAPPER_DEBUG_DIRECTORY));
        }
        if (Boolean.getBoolean(DATAMAPPER_USE_JMX)) {
            this.properties.setProperty("useJMX", "true");
        } else {
            this.properties.setProperty("useJMX", "false");
        }
    }

    @Override
    public GraphRuntimeContext createGraphRuntimeContext() {
        return this.createGraphRuntimeContext(new Properties());
    }

    @Override
    public GraphRuntimeContext createGraphRuntimeContext(Properties properties) {
        GraphRuntimeContext context = new GraphRuntimeContext();
        context.setExecutionType(this.executionType);
        context.setSkipCheckConfig(true);
        context.setAuthorityProxy(authorityProxy);
        context.setDebugMode(false);
        context.setUseJMX(false);
        for (String property : this.propertyNames) {
            if (!this.properties.containsKey(property)) continue;
            try {
                BeanUtils.setProperty((Object)context, (String)property, (Object)this.properties.get(property));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if (Boolean.getBoolean(DATAMAPPER_DEBUG_MODE)) {
            context.setVerboseMode(true);
            context.setLogLevel(Level.INFO);
        } else {
            context.setVerboseMode(false);
            context.setLogLevel(Level.WARN);
            context.setTrackingInterval(Integer.MAX_VALUE);
        }
        if (properties != null) {
            context.addAdditionalProperties(properties);
        }
        context.setClassLoader(this.classLoader);
        return context;
    }
}

