/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.clover.impl;

import com.mulesoft.mule.module.datamapper.clover.CloverEngineConfig;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverEngineImpl;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetel.graph.runtime.EngineInitializer;
import org.jetel.plugin.PluginLocation;
import org.mule.api.MuleContext;
import org.mule.module.launcher.FineGrainedControlClassLoader;

public class CloverEngineManager {
    private final ConcurrentHashMap<String, CloverEngineImpl> engineByApp;
    private Lock accessLock = new ReentrantLock();

    public CloverEngineManager(CloverEngineConfig cloverEngineConfig, ConcurrentHashMap<String, CloverEngineImpl> map) {
        this.engineByApp = map;
        this.initPlugins(cloverEngineConfig);
    }

    private void initPlugins(CloverEngineConfig cloverEngineConfig) {
        FineGrainedControlClassLoader controlClassLoader = this.generateFilteredClassLoader();
        String[] cloverPluginDirPaths = cloverEngineConfig.getCloverPluginDirPath().split(";");
        HashSet<String> uniquePaths = new HashSet<String>(Arrays.asList(cloverPluginDirPaths));
        ArrayList<PluginLocation> plugins = new ArrayList<PluginLocation>();
        try {
            for (String cloverPluginDirPath : uniquePaths) {
                File[] children;
                File file = new File(cloverPluginDirPath);
                for (File child : children = file.listFiles()) {
                    PluginLocation pluginLocation = new PluginLocation(child.toURI().toURL(), (ClassLoader)controlClassLoader);
                    plugins.add(pluginLocation);
                }
            }
            EngineInitializer.initEngine((PluginLocation[])plugins.toArray(new PluginLocation[plugins.size()]), null, null);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private FineGrainedControlClassLoader generateFilteredClassLoader() {
        return new FineGrainedControlClassLoader(new URL[0], this.getClass().getClassLoader(), new HashSet<String>(this.getFilteredPackages()));
    }

    private List<String> getFilteredPackages() {
        return Arrays.asList("-net.sf.saxon", "-org.apache.commons.beanutils");
    }

    public CloverEngineImpl getCloverEngine(MuleContext context) {
        String id = context.getConfiguration().getId();
        return this.getCloverEngine(id);
    }

    public CloverEngineImpl getCloverEngine(String id) {
        if (!this.engineByApp.contains(id)) {
            this.engineByApp.putIfAbsent(id, new CloverEngineImpl());
        }
        return this.engineByApp.get(id);
    }

    public void dispose(MuleContext muleContext) {
        String id = muleContext.getConfiguration().getId();
        this.dispose(id);
    }

    public void dispose(String id) {
        try {
            this.accessLock.lock();
            if (this.engineByApp.contains(id)) {
                this.engineByApp.get(id).dispose();
                this.engineByApp.remove(id);
            }
        }
        finally {
            this.accessLock.unlock();
        }
    }
}

