/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.clover;

import com.mulesoft.mule.module.datamapper.api.GraphExecutor;
import com.mulesoft.mule.module.datamapper.api.GraphExecutorFactory;
import com.mulesoft.mule.module.datamapper.api.GraphProvider;
import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.clover.api.CloverGraphFactory;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverEngineImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverEngineManager;
import com.mulesoft.mule.module.datamapper.impl.DefaultGraphExecutor;
import java.io.InputStream;
import org.jetel.graph.TransformationGraph;
import org.jetel.graph.runtime.ExecutionType;

public abstract class AbstractCloverGraphExecutorFactory
implements GraphExecutorFactory {
    private CloverEngineManager cloverEngineManager;

    protected AbstractCloverGraphExecutorFactory(CloverEngineManager cloverEngineManager) {
        this.cloverEngineManager = cloverEngineManager;
    }

    @Override
    public void init() {
    }

    @Override
    public GraphExecutor createGraphExecutor(String transformationGraphPath) throws DataMapperCreationException {
        GraphProvider<TransformationGraph> graphProvider = this.createGraphProvider(this.createGraphFactory(transformationGraphPath, ExecutionType.SINGLE_THREAD_EXECUTION));
        GraphProvider<TransformationGraph> asyncGraphProvider = this.createGraphProvider(this.createGraphFactory(transformationGraphPath, ExecutionType.MULTI_THREAD_EXECUTION));
        return DefaultGraphExecutor.createGraphExecutor(graphProvider, asyncGraphProvider, this.getCloverEngine());
    }

    protected abstract CloverEngineImpl getCloverEngine();

    @Override
    public GraphExecutor createGraphExecutor(InputStream transformationGraphPath) throws DataMapperCreationException {
        GraphProvider<TransformationGraph> graphProvider = this.createGraphProvider(this.createGraphFactory(transformationGraphPath, ExecutionType.SINGLE_THREAD_EXECUTION));
        GraphProvider<TransformationGraph> asyncGraphProvider = this.createGraphProvider(this.createGraphFactory(transformationGraphPath, ExecutionType.MULTI_THREAD_EXECUTION));
        return DefaultGraphExecutor.createGraphExecutor(graphProvider, asyncGraphProvider, this.getCloverEngine());
    }

    protected abstract GraphProvider<TransformationGraph> createGraphProvider(CloverGraphFactory var1) throws DataMapperCreationException;

    public CloverEngineManager getCloverEngineManager() {
        return this.cloverEngineManager;
    }

    protected abstract CloverGraphFactory createGraphFactory(String var1, ExecutionType var2);

    protected abstract CloverGraphFactory createGraphFactory(InputStream var1, ExecutionType var2);
}

