/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.transform.function;

import com.mulesoft.datamapper.transform.function.AbstractExpressionLanguageFunction;
import com.mulesoft.datamapper.transform.function.DateFunctionUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.mule.api.el.ExpressionLanguageContext;

public class Str2DateFunction
extends AbstractExpressionLanguageFunction {
    public Object call(Object[] params, ExpressionLanguageContext context) {
        if (params.length == 2) {
            if (this.isString(params[0]) && this.isString(params[1])) {
                if (params[0] == null) {
                    return null;
                }
                String dateString = (String)params[0];
                String parsePatterns = (String)params[1];
                return this.parseDate(dateString, parsePatterns, TimeZone.getDefault());
            }
        } else if (params.length == 3 && this.isString(params[0]) && this.isString(params[1]) && this.isTimeZone(params[2])) {
            if (params[0] == null) {
                return null;
            }
            String dateString = (String)params[0];
            String parsePatterns = (String)params[1];
            return this.parseDate(dateString, parsePatterns, (TimeZone)params[2]);
        }
        throw new IllegalArgumentException("Illegal call " + this.getSignatureFromParams("str2date", params) + " to str2date(String dateString, String parsePattern) or str2date(String dateString, String parsePattern , TimeZone timeZone)");
    }

    public Date parseDate(String dateString, String parsePatterns, TimeZone timeZone) {
        if (dateString == null) {
            return null;
        }
        if (parsePatterns.startsWith("joda:")) {
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)DateFunctionUtils.getAbsolutePattern(parsePatterns));
            fmt = fmt.withZone(DateTimeZone.forTimeZone((TimeZone)timeZone));
            return fmt.parseDateTime(dateString).toDate();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(parsePatterns);
        try {
            simpleDateFormat.setTimeZone(timeZone);
            return simpleDateFormat.parse(dateString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

