/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.transform.function;

import com.mulesoft.datamapper.transform.function.AbstractExpressionLanguageFunction;
import com.mulesoft.datamapper.transform.function.Str2DateFunction;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.time.DateUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.mule.api.el.ExpressionLanguageContext;

public class Str2CalendarFunction
extends AbstractExpressionLanguageFunction {
    public Object call(Object[] params, ExpressionLanguageContext context) {
        if (params.length == 2) {
            if (this.isString(params[0]) && this.isString(params[1])) {
                if (params[0] == null) {
                    return null;
                }
                String dateString = (String)params[0];
                String datePattern = (String)params[1];
                return Str2CalendarFunction.stringToCalendar(dateString, datePattern, DateUtils.UTC_TIME_ZONE);
            }
        } else if (params.length == 3 && this.isString(params[0]) && this.isString(params[1]) && this.isTimeZone(params[2])) {
            if (params[0] == null) {
                return null;
            }
            String dateString = (String)params[0];
            String datePattern = (String)params[1];
            return Str2CalendarFunction.stringToCalendar(dateString, datePattern, (TimeZone)params[2]);
        }
        throw new IllegalArgumentException("Illegal call " + this.getSignatureFromParams("str2calendar", params) + " to str2calendar(String dateString,String parsePattern) or str2calendar(String dateString,String parsePattern, TimeZone timeZone)");
    }

    public static String stringToCalendar(String dateString, String datePattern, TimeZone timeZone) {
        if (dateString == null) {
            return null;
        }
        Date date = new Str2DateFunction().parseDate(dateString, datePattern, timeZone);
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        fmt = fmt.withZone(DateTimeZone.forTimeZone((TimeZone)timeZone));
        return fmt.print((ReadableInstant)new DateTime(date.getTime()));
    }
}

