/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.transform.function;

import com.mulesoft.datamapper.exception.DataMapperRuntimeException;
import com.mulesoft.datamapper.transform.LookupTableAware;
import com.mulesoft.datamapper.transform.function.LookupAccessor;
import org.jetel.data.lookup.LookupTable;
import org.jetel.exception.ComponentNotReadyException;
import org.mule.api.el.ExpressionLanguageContext;
import org.mule.api.el.ExpressionLanguageFunction;

public class LookupFunction
implements ExpressionLanguageFunction {
    private LookupTableAware graph;

    public LookupFunction(LookupTableAware graph) {
        this.graph = graph;
    }

    public Object call(Object[] params, ExpressionLanguageContext context) {
        if (params.length != 1) {
            throw new IllegalArgumentException("Missing lookup table parameter or lookup table name parameter");
        }
        Object param = params[0];
        LookupTable lookupTable = null;
        if (param instanceof String) {
            lookupTable = this.graph.getLookupTable(String.valueOf(param));
        } else if (param instanceof LookupTable) {
            lookupTable = (LookupTable)param;
        }
        if (lookupTable == null) {
            throw new IllegalArgumentException("Parameter must be either a String or a LookupTable.");
        }
        if (!lookupTable.isInitialized()) {
            try {
                lookupTable.init();
            }
            catch (ComponentNotReadyException e) {
                throw new DataMapperRuntimeException(e);
            }
        }
        return new LookupAccessor(lookupTable);
    }
}

