/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.transform.function;

import com.mulesoft.datamapper.transform.CloverTypesUtils;
import com.mulesoft.datamapper.transform.DataRecordContext;
import java.util.Map;
import org.jetel.data.DataRecord;
import org.jetel.data.DataRecordFactory;
import org.jetel.data.RecordKey;
import org.jetel.data.lookup.Lookup;
import org.jetel.data.lookup.LookupTable;
import org.jetel.exception.ComponentNotReadyException;
import org.jetel.metadata.DataFieldMetadata;
import org.jetel.metadata.DataRecordMetadata;

public class LookupAccessor {
    private LookupTable lookupTable;
    private Lookup lookup;
    private DataRecordMetadata keyMetadata;
    private RecordKey recordKey;

    public LookupAccessor(LookupTable lookupTable) {
        this.lookupTable = lookupTable;
    }

    public Map<String, Object> get(Object[] args) throws ComponentNotReadyException {
        this.intLookup(args);
        DataRecord input = DataRecordFactory.newRecord((DataRecordMetadata)this.keyMetadata);
        input.init();
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            input.getField(i).setValue(arg);
        }
        this.lookup.seek(input);
        DataRecord next = this.lookup.hasNext() ? (DataRecord)this.lookup.next() : null;
        return next != null ? new DataRecordContext(next) : null;
    }

    private void intLookup(Object[] args) throws ComponentNotReadyException {
        if (this.keyMetadata == null) {
            try {
                this.keyMetadata = this.lookupTable.getKeyMetadata();
                DataRecordMetadata keyMetadata = this.lookupTable.getKeyMetadata();
                this.recordKey = new RecordKey(keyMetadata.getFieldNamesArray(), keyMetadata);
            }
            catch (UnsupportedOperationException e) {
                DataRecordMetadata keyRecordMetadata = new DataRecordMetadata(this.lookupTable.getName() + "_metadata");
                int[] keyFields = new int[args.length];
                for (int i = 0; i < args.length; ++i) {
                    Class<?> aClass = args[i] != null ? args[i].getClass() : null;
                    DataFieldMetadata field = new DataFieldMetadata("_field" + i, CloverTypesUtils.getFieldTypeFromJavaClass(aClass), "|");
                    keyRecordMetadata.addField(field);
                    keyFields[i] = i;
                }
                this.recordKey = new RecordKey(keyFields, keyRecordMetadata);
                this.keyMetadata = keyRecordMetadata;
            }
            this.recordKey.init();
            this.lookup = this.lookupTable.createLookup(this.recordKey);
        }
    }
}

