/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.transform.function;

import com.mulesoft.datamapper.transform.function.AbstractExpressionLanguageFunction;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.time.DateUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.mule.api.el.ExpressionLanguageContext;

public class Long2CalendarFunction
extends AbstractExpressionLanguageFunction {
    public Object call(Object[] params, ExpressionLanguageContext context) {
        if (params.length == 1) {
            if (this.isLong(params[0])) {
                if (params[0] == null) {
                    return null;
                }
                Long milliseconds = (Long)params[0];
                return Long2CalendarFunction.longToCalendar(milliseconds, DateUtils.UTC_TIME_ZONE);
            }
        } else if (params.length == 2 && this.isLong(params[0]) && this.isTimeZone(params[1])) {
            if (params[0] == null) {
                return null;
            }
            Long milliseconds = (Long)params[0];
            return Long2CalendarFunction.longToCalendar(milliseconds, (TimeZone)params[1]);
        }
        throw new IllegalArgumentException("Invalid call " + this.getSignatureFromParams("long2calendar", params) + " long2calendar(Long milliseconds) or long2calendar(Long milliseconds, TimeZone timeZone)");
    }

    public static String longToCalendar(Long milliseconds, TimeZone timeZone) {
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        fmt = fmt.withZone(DateTimeZone.forTimeZone((TimeZone)timeZone));
        DateTime dateTime = new DateTime((Object)new Date(milliseconds));
        return fmt.print((ReadableInstant)dateTime);
    }
}

