/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.transform.function;

import com.mulesoft.datamapper.transform.function.AbstractExpressionLanguageFunction;
import com.mulesoft.datamapper.transform.function.DateFunctionUtils;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.time.DateFormatUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.mule.api.el.ExpressionLanguageContext;

public class Date2StrFunction
extends AbstractExpressionLanguageFunction {
    public Object call(Object[] params, ExpressionLanguageContext context) {
        if (params.length == 2) {
            if (this.isDate(params[0]) && this.isString(params[1])) {
                if (params[0] == null) {
                    return null;
                }
                return Date2StrFunction.dateToString((Date)params[0], (String)params[1], null);
            }
        } else if (this.isDate(params[0]) && this.isString(params[1]) && this.isTimeZone(params[2])) {
            if (params[0] == null) {
                return null;
            }
            return Date2StrFunction.dateToString((Date)params[0], (String)params[1], (TimeZone)params[2]);
        }
        throw new IllegalArgumentException("Illegal call " + this.getSignatureFromParams("date2str", params) + " to date2str(Date date, String pattern)  or date2str(Date date, String pattern, TimeZone timeZone)   ");
    }

    public static String dateToString(Date date, String parsePatterns, TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        if (parsePatterns.startsWith("joda:")) {
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)DateFunctionUtils.getAbsolutePattern(parsePatterns));
            fmt = fmt.withZone(DateTimeZone.forTimeZone((TimeZone)timeZone));
            return fmt.print((ReadableInstant)new DateTime(date.getTime()));
        }
        return DateFormatUtils.format((Date)date, (String)parsePatterns, (TimeZone)timeZone);
    }
}

