/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.transform.function;

import com.mulesoft.datamapper.transform.function.AbstractExpressionLanguageFunction;
import com.mulesoft.datamapper.transform.function.DateFunctionUtils;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTime;
import org.mule.api.el.ExpressionLanguageContext;

public class Calendar2LongFunction
extends AbstractExpressionLanguageFunction {
    public Object call(Object[] params, ExpressionLanguageContext context) {
        if (params.length == 1) {
            if (params[0] == null) {
                return null;
            }
            if (this.isString(params[0])) {
                String dateString = (String)params[0];
                return Calendar2LongFunction.calendarToLong(dateString);
            }
            if (this.isCalendar(params[0])) {
                Calendar calendar = (Calendar)params[0];
                return Calendar2LongFunction.calendarToLong(calendar);
            }
            if (this.isCalendar(params[0])) {
                Date date = (Date)params[0];
                return Calendar2LongFunction.calendarToLong(date);
            }
        }
        throw new IllegalArgumentException("Illegal call " + this.getSignatureFromParams("calendar2long", params) + " to calendar2long(Calendar calendar) ");
    }

    public static Long calendarToLong(String dateString) {
        DateTime dateTime = DateFunctionUtils.parseISO8610DateTime(dateString);
        return dateTime.getMillis();
    }

    public static Long calendarToLong(Calendar inputCalendar) {
        DateTime dateTime = new DateTime((Object)inputCalendar);
        return dateTime.getMillis();
    }

    public static Long calendarToLong(Date inputDate) {
        return inputDate.getTime();
    }
}

