/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.transform.function;

import com.mulesoft.datamapper.transform.function.AbstractExpressionLanguageFunction;
import com.mulesoft.datamapper.transform.function.DateFunctionUtils;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTime;
import org.mule.api.el.ExpressionLanguageContext;

public class Calendar2DateFunction
extends AbstractExpressionLanguageFunction {
    public Object call(Object[] params, ExpressionLanguageContext context) {
        if (params.length == 1) {
            if (params[0] == null) {
                return null;
            }
            if (this.isString(params[0])) {
                String dateString = (String)params[0];
                return Calendar2DateFunction.calendarToDate(dateString);
            }
            if (this.isCalendar(params[0])) {
                Calendar inputCalendar = (Calendar)params[0];
                return Calendar2DateFunction.calendarToDate(inputCalendar);
            }
            if (this.isDate(params[0])) {
                Date inputDate = (Date)params[0];
                return Calendar2DateFunction.calendarToDate(inputDate);
            }
        }
        throw new IllegalArgumentException("Illegal call " + this.getSignatureFromParams("calendar2date", params) + " to calendar2date(Calendar calendar) ");
    }

    public static Date calendarToDate(String dateString) {
        DateTime dateTime = DateFunctionUtils.parseISO8610DateTime(dateString);
        return dateTime.toDate();
    }

    public static Date calendarToDate(Calendar calendar) {
        DateTime dateTime = new DateTime((Object)calendar);
        return dateTime.toDate();
    }

    public static Date calendarToDate(Date date) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.toDate();
    }
}

