/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.transform.converter;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractConverter;

public class UriConverter
extends AbstractConverter {
    protected Object convertToType(Class type, Object value) throws Throwable {
        if (value instanceof String) {
            try {
                return new URI((String)value);
            }
            catch (URISyntaxException e) {
                throw new ConversionException("Cannot create URI from " + value, (Throwable)e);
            }
        }
        if (value instanceof URL) {
            try {
                return new URI(value.toString());
            }
            catch (URISyntaxException e) {
                throw new ConversionException("Cannot create URI from " + value, (Throwable)e);
            }
        }
        throw new ConversionException("Cannot create URI from " + value);
    }

    protected Class getDefaultType() {
        return URI.class;
    }
}

