/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal.impl;

import com.mulesoft.mq.restclient.client.mq.AbstractCourierRestClient;
import com.mulesoft.mq.restclient.client.mq.CourierRestClient;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessageBuilder;
import com.mulesoft.mq.restclient.client.mq.domain.FallbackConfigResult;
import com.mulesoft.mq.restclient.client.mq.domain.Lock;
import com.mulesoft.mq.restclient.client.mq.domain.MessageIdResult;
import com.mulesoft.mq.restclient.client.mq.domain.NewTtl;
import com.mulesoft.mq.restclient.internal.CourierObservable;
import com.mulesoft.mq.restclient.internal.Destination;
import com.mulesoft.mq.restclient.internal.DestinationLocation;
import com.mulesoft.mq.restclient.internal.impl.DefaultCourierObservable;
import com.mulesoft.mq.restclient.internal.impl.LockedMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class DefaultDestination
implements Destination {
    private final CourierRestClient client;
    private final DestinationLocation destinationLocation;
    private Destination.FallbackConfiguration fallbackConfiguration = Destination.FallbackConfiguration.UNKNOWN;
    private boolean primaryRegionDown;
    private long primaryRegionStatusLastChecked;
    private boolean fallbackHasMessages;
    private long fallbackMessagesLastChecked;

    @Override
    public long getFallbackMessagesLastChecked() {
        return this.fallbackMessagesLastChecked;
    }

    public DefaultDestination(CourierRestClient client, DestinationLocation destinationLocation) {
        this.client = client;
        this.destinationLocation = destinationLocation;
    }

    @Override
    public String getName() {
        return this.destinationLocation.getName();
    }

    @Override
    public String getName(boolean getFallbackName) {
        if (getFallbackName) {
            return this.destinationLocation.getFallbackName();
        }
        return this.getName();
    }

    @Override
    public void setFallbackName(String fallbackName) {
        this.destinationLocation.setFallbackName(fallbackName);
    }

    @Override
    public void setFallbackRegion(String fallbackRegion) {
        this.destinationLocation.setFallbackRegion(fallbackRegion);
    }

    @Override
    public Optional<String> getFallbackRegion() {
        return this.destinationLocation.getFallbackRegion();
    }

    @Override
    public Destination.FallbackConfiguration getFallbackConfiguration() {
        return this.fallbackConfiguration;
    }

    @Override
    public void setFallbackConfiguration(Destination.FallbackConfiguration fallbackConfiguration) {
        this.fallbackConfiguration = fallbackConfiguration;
    }

    @Override
    public boolean getPrimaryRegionDown() {
        return this.primaryRegionDown;
    }

    @Override
    public void setPrimaryRegionDown(boolean primaryRegionDown) {
        this.primaryRegionDown = primaryRegionDown;
    }

    @Override
    public long getPrimaryRegionStatusLastChecked() {
        return this.primaryRegionStatusLastChecked;
    }

    @Override
    public void setPrimaryRegionStatusLastChecked(long primaryRegionStatusLastChecked) {
        this.primaryRegionStatusLastChecked = primaryRegionStatusLastChecked;
    }

    @Override
    public boolean getFallbackHasMessages() {
        return this.fallbackHasMessages;
    }

    @Override
    public void setFallbackHasMessages(boolean fallbackHasMessages) {
        this.fallbackHasMessages = fallbackHasMessages;
    }

    @Override
    public void setFallbackMessagesLastChecked(long fallbackMessagesLastChecked) {
        this.fallbackMessagesLastChecked = fallbackMessagesLastChecked;
    }

    public DefaultCourierObservable<FallbackConfigResult> fetchFallbackConfiguration(boolean useFallbackDestination, int retryCount) {
        return new DefaultCourierObservable<FallbackConfigResult>(this.client.getFallbackConfig(this.destinationLocation, useFallbackDestination, retryCount));
    }

    public DefaultCourierObservable<MessageIdResult> send(AnypointMQMessage message, boolean useFallbackDestination, int retryCount) {
        return new DefaultCourierObservable<MessageIdResult>(this.client.send(this.destinationLocation, message, useFallbackDestination, retryCount));
    }

    public DefaultCourierObservable<List<MessageIdResult>> send(List<AnypointMQMessage> messages, boolean useFallbackDestination, int retryCount) {
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.send(this.destinationLocation, messages, useFallbackDestination, retryCount));
    }

    public DefaultCourierObservable<List<AnypointMQMessage>> receive() {
        return this.receive(1, 0L, 120000L, false, false, AbstractCourierRestClient.MAX_RETRIES);
    }

    public DefaultCourierObservable<List<AnypointMQMessage>> receive(int batchSize, long pollingTime, long lockTtl, boolean useFallbackDestination, boolean shortPolling, int retryCount) {
        return new DefaultCourierObservable<List<AnypointMQMessage>>(this.client.receive(this.destinationLocation, batchSize, pollingTime, lockTtl, useFallbackDestination, shortPolling, retryCount));
    }

    public DefaultCourierObservable<List<MessageIdResult>> ack(List<Lock> locks, boolean usedFallbackDestination) {
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.ack(this.destinationLocation, locks, usedFallbackDestination));
    }

    @Override
    public CourierObservable<MessageIdResult> ack(Lock lock, boolean usedFallbackDestination) {
        return new DefaultCourierObservable<MessageIdResult>(this.client.ack(this.destinationLocation, lock, usedFallbackDestination));
    }

    public DefaultCourierObservable<List<MessageIdResult>> nack(List<Lock> locks, boolean usedFallbackDestination) {
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.nack(this.destinationLocation, locks, usedFallbackDestination));
    }

    @Override
    public CourierObservable<MessageIdResult> nack(Lock lock, boolean usedFallbackDestination) {
        return new DefaultCourierObservable<MessageIdResult>(this.client.nack(this.destinationLocation, lock, usedFallbackDestination));
    }

    public DefaultCourierObservable<List<MessageIdResult>> modifyLockInterval(List<AnypointMQMessage> messages, int lockInterval, boolean usedFallbackDestination) {
        ArrayList<NewTtl> newTtls = new ArrayList<NewTtl>();
        for (AnypointMQMessage message : messages) {
            newTtls.add(new NewTtl(message.getMessageId(), message.getLockId(), lockInterval));
        }
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.modifyTtl(this.destinationLocation, newTtls, usedFallbackDestination));
    }

    public DefaultCourierObservable<List<MessageIdResult>> modifyLockInterval(List<LockedMessage> lockedMessages, boolean usedFallbackDestination) {
        ArrayList<NewTtl> newTtls = new ArrayList<NewTtl>();
        for (LockedMessage lockedMessage : lockedMessages) {
            newTtls.add(new NewTtl(lockedMessage.getMessage().getMessageId(), lockedMessage.getMessage().getLockId(), lockedMessage.getLockInterval()));
        }
        return new DefaultCourierObservable<List<MessageIdResult>>(this.client.modifyTtl(this.destinationLocation, newTtls, usedFallbackDestination));
    }

    @Override
    public AnypointMQMessageBuilder newMessageBuilder() {
        return new AnypointMQMessageBuilder();
    }
}

