/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine.threading;

import com.mulesoft.mule.runtime.module.batch.BatchProcessingListener;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchJobInstanceStatus;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.engine.BatchEngine;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.BatchStepAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import com.mulesoft.mule.runtime.module.batch.internal.DefaultBatchStep;
import com.mulesoft.mule.runtime.module.batch.util.BatchUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchRecordWork
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(BatchRecordWork.class);
    private final BatchEngine batchEngine;
    private final BatchJobAdapter job;
    private final BatchTransactionContext ctx;
    private final BatchProcessingListener listener;
    private boolean shouldRollback;
    private final List<Record> block;

    public BatchRecordWork(BatchEngine batchEngine, BatchJobAdapter job, BatchTransactionContext ctx, BatchProcessingListener listener, List<Record> block) {
        if (block == null) {
            throw new IllegalArgumentException("Record block must not be null.");
        }
        this.batchEngine = batchEngine;
        this.job = job;
        this.ctx = ctx;
        this.listener = listener;
        this.block = block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.shouldRollback = true;
        try {
            if (this.block == null || this.block.isEmpty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Stepping queue found empty for instance '%s' of job '%s'", this.ctx.getJobInstance().getId(), this.ctx.getJob().getName()));
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Just polled %d records from stepping queue of instance '%s' of job '%s'. %d blocks still remaining", this.block.size(), this.ctx.getJobInstance().getId(), this.ctx.getJob().getName(), this.batchEngine.getBatchQueueManager().steppingQueue(this.ctx.getJobInstance()).size(this.ctx)));
            }
            this.ctx.setBlockSize(this.block.size());
            ArrayList<Record> resultBlock = new ArrayList<Record>(this.block.size());
            HashSet<BatchStepAdapter> steps = new HashSet<BatchStepAdapter>();
            for (Record record : this.block) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                BatchStepAdapter step = this.job.getStepById(record.getCurrentStepId());
                steps.add(step);
                if ((record = step.onRecord(record, this.ctx)) == null) continue;
                resultBlock.add(record);
            }
            BatchJobInstanceAdapter jobInstance = this.batchEngine.updateStatisticsAndRoute(this.ctx, resultBlock);
            for (BatchStepAdapter step : steps) {
                boolean completed = step.finishIfCompleted(jobInstance, this.ctx);
                if (completed) {
                    ((DefaultBatchStep)step).endStepSpan();
                }
                if (completed || !jobInstance.getStatus().isFailure() && jobInstance.getStatus() != BatchJobInstanceStatus.STOPPED) continue;
                ((DefaultBatchStep)step).endStepSpan();
                step.releaseResources(jobInstance);
            }
            this.shouldRollback = false;
        }
        catch (OutOfMemoryError e) {
            logger.error(String.format("Ran out of memory while processing instance of batch job '%s'. Increase heap memory or reduce job's thread count", this.job.getName()), (Throwable)e);
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException || t.getCause() instanceof InterruptedException) {
                logger.error(String.format("Interruption while processing block '%s' for instance '%s' of batch job '%s'. Records will be queued back", this.ctx.getId(), this.ctx.getJobInstance().getId(), this.job.getName()));
            } else {
                logger.error(String.format("Exception found while processing block '%s' for instance '%s' of batch job '%s'. Records will be queued back", this.ctx.getId(), this.ctx.getJobInstance().getId(), this.job.getName()), t);
            }
        }
        finally {
            BatchUtils.completeWorkOnBlock(this.block, this.shouldRollback, this.listener, this.ctx);
        }
    }

    public String toString() {
        return "BatchRecordWork(" + this.job.getName() + ")";
    }
}

