/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.commit;

import com.google.common.collect.ForwardingList;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.internal.commit.RecordAwareEventIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.routing.outbound.EventBuilderConfigurer;
import org.mule.runtime.core.internal.routing.outbound.EventBuilderConfigurerList;
import org.mule.runtime.core.internal.routing.split.Copiable;

public class ImmutableRecordAwareList<T>
extends ForwardingList<T>
implements Copiable<ImmutableRecordAwareList>,
EventBuilderConfigurerList<T> {
    private final List<T> delegate;
    private final List<Record> records;

    public ImmutableRecordAwareList(List<T> delegate, List<Record> records) {
        Preconditions.checkArgument((delegate.size() == records.size() ? 1 : 0) != 0, (String)"lists size do not match");
        this.delegate = delegate;
        this.records = records;
    }

    protected List<T> delegate() {
        return this.delegate;
    }

    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    public Iterator<EventBuilderConfigurer> eventBuilderConfigurerIterator() {
        return new RecordAwareEventIterator<T>(this.delegate.iterator(), this.records.iterator());
    }

    public ImmutableRecordAwareList copy() {
        return new ImmutableRecordAwareList<T>(new ArrayList<T>(this.delegate), new ArrayList<Record>(this.records));
    }
}

