/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.api.record;

import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.runtime.api.metadata.TypedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RecordELAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordELAdapter.class);
    private final Record record;
    private Map<String, Object> vars;

    public RecordELAdapter(Record record) {
        this.record = record;
        this.vars = RecordELAdapter.extractVariables(record);
    }

    private static Map<String, Object> extractVariables(Record record) {
        return record.getAllVariables().entrySet().stream().filter(entry -> {
            boolean isNull;
            boolean bl = isNull = ((TypedValue)entry.getValue()).getValue() == null;
            if (isNull) {
                LOGGER.warn("Filtering a null variable with name {}", entry.getKey());
            }
            return !isNull;
        }).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((TypedValue)entry.getValue()).getValue()));
    }

    public Object getPayload() {
        return this.getValue(this.record.getPayload());
    }

    public void setPayload(Object payload) {
        this.record.setPayload(this.asTypedValue(payload));
    }

    public Object getAttributes() {
        return this.getValue(this.record.getAttributes());
    }

    public void setAttributes(Object attributes) {
        this.record.setPayload(this.record.getPayload(), this.asTypedValue(attributes));
    }

    public Map<String, Object> getVars() {
        return this.vars;
    }

    public void setVars(Map<String, Object> vars) {
        this.vars = vars;
    }

    private <T> T getValue(TypedValue<T> typedValue) {
        return (T)(typedValue != null ? typedValue.getValue() : null);
    }

    private <T> TypedValue<T> asTypedValue(Object value) {
        return value instanceof TypedValue ? (TypedValue)value : TypedValue.of((Object)value);
    }
}

