/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.tests.infrastructure.installation;

import com.google.common.collect.Lists;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.ExternalResource;

public class ClusterSystemProperties
extends ExternalResource {
    private static final String LOCALHOST_IP = "127.0.0.1";
    private final int clusterSize;
    private final boolean clientMode;

    public ClusterSystemProperties(int clusterSize) {
        this(clusterSize, false);
    }

    public ClusterSystemProperties(int clusterSize, boolean clientMode) {
        this.clusterSize = clusterSize;
        this.clientMode = clientMode;
    }

    protected void before() throws Exception {
        System.setProperty("mule.clusterId", UUID.randomUUID().toString());
        System.setProperty("mule.clusterSize", String.valueOf(this.clusterSize));
        System.setProperty("mule.cluster.multicastenabled", "false");
        System.setProperty("mule.cluster.networkinterfaces", LOCALHOST_IP);
        System.setProperty("mule.cluster.nodes", StringUtils.join((Iterable)Lists.newArrayList((Object[])new String[]{LOCALHOST_IP}), (String)","));
        System.setProperty("mule.clusterNodeId", "1");
        System.setProperty("mule.cluster.clientmode", String.valueOf(this.clientMode));
    }

    protected void after() {
        System.clearProperty("mule.clusterId");
        System.clearProperty("mule.clusterSize");
        System.clearProperty("mule.cluster.multicastenabled");
        System.clearProperty("mule.cluster.networkinterfaces");
        System.clearProperty("mule.cluster.nodes");
        System.clearProperty("mule.clusterNodeId");
        System.clearProperty("mule.cluster.clientclusterid");
        System.clearProperty("mule.cluster.clientclusterpassword");
        System.clearProperty("mule.cluster.clientmode");
    }

    public void updateClusterNodeIdProperty(String nodeId) {
        System.setProperty("mule.clusterNodeId", nodeId);
    }
}

