/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.retry;

import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.core.api.util.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedRetrier {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedRetrier.class);
    private final HashMap<String, ScheduledExecutorService> scheduledExecutors = new HashMap();
    private final long delay;
    private final TimeUnit unit;

    public FixedRetrier(long delay, TimeUnit unit) {
        this.delay = delay;
        this.unit = unit;
    }

    private void scheduleRetry(String key, Runnable runnable) {
        ScheduledExecutorService executor = this.scheduledExecutors.computeIfAbsent(key, k -> Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory(k)));
        executor.schedule(() -> this.tryOrReschedule(key, runnable), this.delay, this.unit);
    }

    public void tryOrReschedule(String key, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            LOGGER.debug("Failed to complete task {}. It will be rescheduled after {} {}", new Object[]{key, this.delay, this.unit, e});
            this.scheduleRetry(key, runnable);
        }
    }

    public void dispose() {
        this.scheduledExecutors.forEach((key, value) -> value.shutdownNow());
    }
}

