/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.extension;

import com.mulesoft.mule.runtime.core.api.util.license.LicenseUtils;
import com.mulesoft.mule.runtime.core.api.util.license.MuleLicenseException;
import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.mule.runtime.gw.api.config.PlatformClientConfiguration;
import com.mulesoft.mule.runtime.gw.api.exception.GatewayConfigurationException;
import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.extension.GatewayEntitlementCheck;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GatewayEntitledCoreExtension
implements DeploymentListener,
MuleCoreExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayEntitledCoreExtension.class);
    private boolean extensionLoaded;
    protected ArtifactClassLoader containerClassLoader;
    private PlatformClientConfiguration platformClientConfiguration = new GatewayConfiguration().platformClient();

    public void initialise() throws InitialisationException {
        try {
            GatewayEntitlementCheck.checkGatewayEntitlement(LicenseUtils.getLicenseKey((String)"mule-ee"));
            this.initialiseCoreExtension();
            this.extensionLoaded = true;
        }
        catch (MuleLicenseException e) {
            LOGGER.debug("Error initialising core extension {}. {}", (Object)this.getName(), (Object)ExceptionDescriptor.errorMessage(e));
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public boolean extensionLoaded() {
        return this.extensionLoaded;
    }

    public boolean onlineMode() {
        try {
            return !this.platformClientConfiguration.isOfflineModeEnabled();
        }
        catch (GatewayConfigurationException ex) {
            LOGGER.debug("Error decrypting credentials, will continue in offline mode.", (Throwable)ex);
            return false;
        }
    }

    public void setContainerClassLoader(ArtifactClassLoader artifactClassLoader) {
        this.containerClassLoader = artifactClassLoader;
    }

    protected abstract void initialiseCoreExtension();
}

