/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.adapter;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.client.dto.IdentityManagementDto;
import com.mulesoft.mule.runtime.gw.client.dto.PolicyDefinitionDto;
import com.mulesoft.mule.runtime.gw.client.dto.PolicyTemplateKeyDto;
import com.mulesoft.mule.runtime.gw.client.exception.IncompatibleApiException;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PolicyDefinitionBuilder {
    private static final String IS_WSDL_ENDPOINT_PROPERTY = "isWsdlEndpoint";
    private static final String POLICY_ID_PROPERTY = "policyId";
    private static final String WSDL_ENDPOINT_TYPE = "wsdl";
    private static final String IDENTITY_MANAGEMENT_PREFIX = "identityManagement";
    private static final String IDENTITY_MANAGEMENT_TOKEN_URL = "identityManagementTokenUrl";
    private static final String IDENTITY_MANAGEMENT_CLIENT_ID = "identityManagementClientId";
    private static final String IDENTITY_MANAGEMENT_CLIENT_SECRET = "identityManagementClientSecret";

    public PolicyDefinition from(ApiKey apiKey, PolicyDefinitionDto dto, String endpointType, IdentityManagementDto identityManagement) {
        ArrayList resourcePointcuts = new ArrayList();
        if (dto.getPointcutData() != null) {
            dto.getPointcutData().forEach(pointcutData -> resourcePointcuts.add(new HttpResourcePointcut(pointcutData.getUriTemplateRegex(), pointcutData.getMethodRegex())));
        }
        int order = this.resolvePoliciesWithNoOrder(dto.getOrder());
        if (!this.isAValidPolicyTemplateKey(dto.getPolicyTemplateKey())) {
            throw new IncompatibleApiException("The API is not Mule 4 compatible.");
        }
        PolicyTemplateKey templateKey = new PolicyTemplateKey(dto.getPolicyTemplateKey().getGroupId(), dto.getPolicyTemplateKey().getAssetId(), dto.getPolicyTemplateKey().getVersion());
        HashMap<String, Object> configuration = new HashMap<String, Object>(dto.getConfiguration());
        configuration.put(IS_WSDL_ENDPOINT_PROPERTY, this.isWsdlEndpointType(endpointType));
        configuration.put(POLICY_ID_PROPERTY, dto.getId());
        PolicyConfiguration policyConfiguration = new PolicyConfiguration(configuration);
        this.setIdentityManagement(configuration, identityManagement);
        return new PolicyDefinition(dto.getId(), templateKey, apiKey, resourcePointcuts, order, policyConfiguration);
    }

    private int resolvePoliciesWithNoOrder(int order) {
        return Math.abs(order) * 10 + 1;
    }

    private boolean isWsdlEndpointType(String endpointType) {
        return WSDL_ENDPOINT_TYPE.equalsIgnoreCase(endpointType);
    }

    private void setIdentityManagement(Map<String, Object> configuration, IdentityManagementDto identityManagement) {
        if (identityManagement != null) {
            configuration.put(IDENTITY_MANAGEMENT_TOKEN_URL, identityManagement.getTokenUrl());
            this.setIdentityManagementClient(configuration, identityManagement);
        }
    }

    private void setIdentityManagementClient(Map<String, Object> configuration, IdentityManagementDto identityManagement) {
        if (identityManagement.hasClient()) {
            configuration.put(IDENTITY_MANAGEMENT_CLIENT_ID, identityManagement.getClientId());
            configuration.put(IDENTITY_MANAGEMENT_CLIENT_SECRET, identityManagement.getClientSecret());
        }
    }

    private boolean isAValidPolicyTemplateKey(PolicyTemplateKeyDto dto) {
        return dto.getGroupId() != null && dto.getAssetId() != null && dto.getVersion() != null;
    }
}

