/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.auth;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mulesoft.mule.runtime.gw.api.time.DateTime;
import com.mulesoft.mule.runtime.gw.client.auth.AccessTokens;
import com.mulesoft.mule.runtime.gw.client.model.PortalAuthentication;
import java.util.Base64;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessTokenManager.class);
    private static final String EXP_CLAIM = "exp";
    private static final String IAT_CLAIM = "iat";
    private final ReentrantReadWriteLock accessTokenLock = new ReentrantReadWriteLock();
    private AccessTokens token = AccessTokens.invalidTokens();

    public AccessTokens getUpdatedTokens(Supplier<String> coreServicesTokenProvider, Function<String, PortalAuthentication> platformTokenProvider) {
        try {
            this.accessTokenLock.writeLock().lock();
            if (this.token.haveExpired()) {
                LOGGER.debug("The platform token has expired, requesting a new one.");
                this.invalidateToken();
            }
            String coreServicesToken = this.token.getCoreServicesToken();
            String platformAccessToken = this.token.getApiManagerToken();
            if (coreServicesToken == null) {
                coreServicesToken = coreServicesTokenProvider.get();
                platformAccessToken = null;
                this.token = new AccessTokens(coreServicesToken);
            }
            if (platformAccessToken == null) {
                PortalAuthentication portalAuthentication = platformTokenProvider.apply(coreServicesToken);
                this.token = new AccessTokens(coreServicesToken, portalAuthentication.getToken(), portalAuthentication.getRootOrgId(), this.calculateExpiration(portalAuthentication.getToken()));
            }
            AccessTokens accessTokens = this.token;
            return accessTokens;
        }
        catch (Exception e) {
            this.invalidateToken();
            throw e;
        }
        finally {
            this.accessTokenLock.writeLock().unlock();
        }
    }

    public void reset() {
        this.accessTokenLock.writeLock().lock();
        try {
            this.invalidateToken();
        }
        finally {
            this.accessTokenLock.writeLock().unlock();
        }
    }

    public void resetIfEquals(String accessTokenInUse) {
        try {
            this.accessTokenLock.writeLock().lock();
            if (accessTokenInUse != null && this.token != null && accessTokenInUse.equals(this.token.getCoreServicesToken())) {
                this.invalidateToken();
            }
        }
        finally {
            this.accessTokenLock.writeLock().unlock();
        }
    }

    private void invalidateToken() {
        this.token = AccessTokens.invalidTokens();
    }

    private DateTime calculateExpiration(String platformToken) {
        String[] tokenParts;
        if (platformToken != null && (tokenParts = platformToken.split("\\.")).length >= 2) {
            try {
                JsonObject tokenBody = JsonParser.parseString((String)new String(Base64.getMimeDecoder().decode(tokenParts[1]))).getAsJsonObject();
                return DateTime.now().plusMillis((int)(tokenBody.get(EXP_CLAIM).getAsLong() - tokenBody.get(IAT_CLAIM).getAsLong() - 120L) * 1000);
            }
            catch (Exception e) {
                LOGGER.debug("Error parsing the jwt: {}.", (Object)e.getMessage());
            }
        }
        LOGGER.debug("The expiration information of the Json Web Token, from platform services, could not be extracted.");
        return null;
    }
}

