/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.api.config;

import com.mulesoft.mule.runtime.gw.api.config.RuntimeConfiguration;
import java.io.File;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class PlatformServicesConfiguration
extends RuntimeConfiguration {
    public static final String POLL_APIS_ENABLED = "anypoint.platform.poll_policies_enabled";
    private static final boolean POLL_APIS_ENABLED_DEFAULT = true;
    public static final String POLL_CLIENTS_ENABLED = "anypoint.platform.poll_clients_enabled";
    private static final boolean POLL_CLIENTS_ENABLED_DEFAULT = true;
    public static final String KEEP_ALIVE_ENABLED = "anypoint.platform.api_keep_alive_enabled";
    private static final boolean KEEP_ALIVE_ENABLED_DEFAULT = true;
    private static final String APIS_LOCATION = "anypoint.platform.apis_location";

    public boolean getApisPollEnabled() {
        return this.parseBooleanOrDefault(POLL_APIS_ENABLED, true);
    }

    public boolean getApiKeepAliveEnabled() {
        return this.parseBooleanOrDefault(KEEP_ALIVE_ENABLED, true);
    }

    public boolean getClientsPollEnabled() {
        return this.parseBooleanOrDefault(POLL_CLIENTS_ENABLED, true);
    }

    public Optional<File> apisFolder() {
        String apiLocation = System.getProperty(APIS_LOCATION);
        return Optional.ofNullable(StringUtils.trimToNull((String)apiLocation)).map(File::new);
    }

    public ApisInfoSource apisInfoSource() {
        if (this.getApisPollEnabled()) {
            return ApisInfoSource.POLLING;
        }
        if (this.apisFolder().isPresent()) {
            return ApisInfoSource.FILE_SYSTEM;
        }
        return ApisInfoSource.DISABLED;
    }

    public static enum ApisInfoSource {
        POLLING,
        FILE_SYSTEM,
        DISABLED;

    }
}

