/*
 * Decompiled with CFR 0.152.
 */
package amf.plugins.document.webapi.validation.json;

import org.json.JSONException;
import org.json.JSONTokener;

public class JSONObject
extends org.json.JSONObject {
    public JSONObject(JSONTokener jSONTokener) throws JSONException {
        if (jSONTokener.nextClean() != '{') {
            throw jSONTokener.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = jSONTokener.nextClean();
            switch (c) {
                case '\u0000': {
                    throw jSONTokener.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            jSONTokener.back();
            String string = jSONTokener.nextValue().toString();
            c = jSONTokener.nextClean();
            if (c != ':') {
                throw jSONTokener.syntaxError("Expected a ':' after a key");
            }
            if (string != null) {
                if (this.opt(string) != null) {
                    throw jSONTokener.syntaxError("Duplicate key \"" + string + "\"");
                }
                Object object = jSONTokener.nextValue();
                if (object != null) {
                    this.put(string, object);
                }
            }
            switch (jSONTokener.nextClean()) {
                case ',': 
                case ';': {
                    if (jSONTokener.nextClean() == '}') {
                        throw jSONTokener.syntaxError("Invalid trailing comma");
                    }
                    jSONTokener.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw jSONTokener.syntaxError("Expected a ',' or '}'");
    }
}

