/*
 * Decompiled with CFR 0.152.
 */
package amf.core;

import amf.client.plugins.AMFDocumentPlugin;
import amf.client.plugins.AMFFeaturePlugin;
import amf.client.remote.Content;
import amf.core.AMFCompiler$;
import amf.core.Root;
import amf.core.Root$;
import amf.core.benchmark.ExecutionLog$;
import amf.core.client.ParsingOptions;
import amf.core.exception.CyclicReferenceException;
import amf.core.exception.UnsupportedMediaTypeException;
import amf.core.exception.UnsupportedVendorException;
import amf.core.model.document.BaseUnit;
import amf.core.model.document.EncodesModel;
import amf.core.model.document.ExternalFragment;
import amf.core.model.document.ExternalFragment$;
import amf.core.model.domain.ExternalDomainElement;
import amf.core.model.domain.ExternalDomainElement$;
import amf.core.parser.ErrorHandler;
import amf.core.parser.ParsedDocument;
import amf.core.parser.ParsedReference;
import amf.core.parser.ParsedReference$;
import amf.core.parser.ParserContext;
import amf.core.parser.ParserContext$;
import amf.core.parser.RefContainer;
import amf.core.parser.Reference;
import amf.core.parser.ReferenceCollector;
import amf.core.parser.ReferenceHandler;
import amf.core.parser.ReferenceKind;
import amf.core.parser.ReferenceResolutionResult;
import amf.core.registries.AMFPluginsRegistry$;
import amf.core.remote.Cache;
import amf.core.remote.Context;
import amf.core.remote.Context$;
import amf.core.remote.FileMediaType$;
import amf.core.remote.PathResolutionError;
import amf.core.remote.Platform;
import amf.core.remote.Vendor;
import amf.core.utils.package$;
import amf.internal.environment.Environment;
import amf.plugins.features.validation.ParserSideValidations$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URISyntaxException;
import org.yaml.model.YNode;
import org.yaml.model.YNode$;
import org.yaml.model.YPart;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t\rd\u0001B\u0001\u0003\u0001\u001d\u00111\"Q'G\u0007>l\u0007/\u001b7fe*\u00111\u0001B\u0001\u0005G>\u0014XMC\u0001\u0006\u0003\r\tWNZ\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\t\u001f\u0001\u0011)\u0019!C\u0001!\u00051!/Y<Ve2,\u0012!\u0005\t\u0003%eq!aE\f\u0011\u0005QQQ\"A\u000b\u000b\u0005Y1\u0011A\u0002\u001fs_>$h(\u0003\u0002\u0019\u0015\u00051\u0001K]3eK\u001aL!AG\u000e\u0003\rM#(/\u001b8h\u0015\tA\"\u0002\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u0012\u0003\u001d\u0011\u0018m^+sY\u0002B\u0001b\b\u0001\u0003\u0006\u0004%\t\u0001I\u0001\u0007e\u0016lw\u000e^3\u0016\u0003\u0005\u0002\"A\t\u0013\u000e\u0003\rR!a\b\u0002\n\u0005\u0015\u001a#\u0001\u0003)mCR4wN]7\t\u0011\u001d\u0002!\u0011!Q\u0001\n\u0005\nqA]3n_R,\u0007\u0005\u0003\u0005*\u0001\t\u0015\r\u0011\"\u0001+\u0003\u0011\u0011\u0017m]3\u0016\u0003-\u00022!\u0003\u0017/\u0013\ti#B\u0001\u0004PaRLwN\u001c\t\u0003E=J!\u0001M\u0012\u0003\u000f\r{g\u000e^3yi\"A!\u0007\u0001B\u0001B\u0003%1&A\u0003cCN,\u0007\u0005\u0003\u00055\u0001\t\u0015\r\u0011\"\u00016\u0003%iW\rZ5b)f\u0004X-F\u00017!\rIA&\u0005\u0005\tq\u0001\u0011\t\u0011)A\u0005m\u0005QQ.\u001a3jCRK\b/\u001a\u0011\t\u0011i\u0002!Q1A\u0005\u0002U\naA^3oI>\u0014\b\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\u0002\u000fY,g\u000eZ8sA!Aa\b\u0001BC\u0002\u0013\u0005q(A\u0007sK\u001a,'/\u001a8dK.Kg\u000eZ\u000b\u0002\u0001B\u0011\u0011\tR\u0007\u0002\u0005*\u00111IA\u0001\u0007a\u0006\u00148/\u001a:\n\u0005\u0015\u0013%!\u0004*fM\u0016\u0014XM\\2f\u0017&tG\r\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003A\u00039\u0011XMZ3sK:\u001cWmS5oI\u0002B\u0001\"\u0013\u0001\u0003\u0006\u0004%IAS\u0001\u0006G\u0006\u001c\u0007.Z\u000b\u0002\u0017B\u0011!\u0005T\u0005\u0003\u001b\u000e\u0012QaQ1dQ\u0016D\u0001b\u0014\u0001\u0003\u0002\u0003\u0006IaS\u0001\u0007G\u0006\u001c\u0007.\u001a\u0011\t\u0011E\u0003!Q1A\u0005\nI\u000b1BY1tK\u000e{g\u000e^3yiV\t1\u000bE\u0002\nYQ\u0003\"!Q+\n\u0005Y\u0013%!\u0004)beN,'oQ8oi\u0016DH\u000f\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003T\u00031\u0011\u0017m]3D_:$X\r\u001f;!\u0011!Q\u0006A!b\u0001\n\u0003Y\u0016aA3omV\tA\f\u0005\u0002^E6\taL\u0003\u0002`A\u0006YQM\u001c<je>tW.\u001a8u\u0015\t\tG!\u0001\u0005j]R,'O\\1m\u0013\t\u0019gLA\u0006F]ZL'o\u001c8nK:$\b\u0002C3\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\u0002\t\u0015tg\u000f\t\u0005\tO\u0002\u0011)\u0019!C\u0001Q\u0006q\u0001/\u0019:tS:<w\n\u001d;j_:\u001cX#A5\u0011\u0005)lW\"A6\u000b\u00051\u0014\u0011AB2mS\u0016tG/\u0003\u0002oW\nq\u0001+\u0019:tS:<w\n\u001d;j_:\u001c\b\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011B5\u0002\u001fA\f'o]5oO>\u0003H/[8og\u0002BQA\u001d\u0001\u0005\u0002M\fa\u0001P5oSRtDc\u0003;wobL(p\u001f?~}~\u0004\"!\u001e\u0001\u000e\u0003\tAQaD9A\u0002EAQaH9A\u0002\u0005BQ!K9A\u0002-BQ\u0001N9A\u0002YBQAO9A\u0002YBqAP9\u0011\u0002\u0003\u0007\u0001\tC\u0003Jc\u0002\u00071\nC\u0004RcB\u0005\t\u0019A*\t\u000fi\u000b\b\u0013!a\u00019\"9q-\u001dI\u0001\u0002\u0004I\u0007\u0002CA\u0002\u0001\t\u0007I\u0011\u0001\t\u0002\tA\fG\u000f\u001b\u0005\b\u0003\u000f\u0001\u0001\u0015!\u0003\u0012\u0003\u0015\u0001\u0018\r\u001e5!\u0011%\tY\u0001\u0001b\u0001\n\u0013\ti!A\u0004d_:$X\r\u001f;\u0016\u00039Bq!!\u0005\u0001A\u0003%a&\u0001\u0005d_:$X\r\u001f;!\u0011!\t)\u0002\u0001b\u0001\n\u0013\u0001\u0012\u0001\u00037pG\u0006$\u0018n\u001c8\t\u000f\u0005e\u0001\u0001)A\u0005#\u0005IAn\\2bi&|g\u000e\t\u0005\n\u0003;\u0001!\u0019!C\u0005\u0003?\t1a\u0019;y+\u0005!\u0006bBA\u0012\u0001\u0001\u0006I\u0001V\u0001\u0005GRD\b\u0005C\u0004\u0002(\u0001!\t!!\u000b\u0002\u000b\t,\u0018\u000e\u001c3\u0015\u0005\u0005-\u0002CBA\u0017\u0003g\t9$\u0004\u0002\u00020)\u0019\u0011\u0011\u0007\u0006\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u00026\u0005=\"A\u0002$viV\u0014X\r\u0005\u0003\u0002:\u0005\rSBAA\u001e\u0015\u0011\ti$a\u0010\u0002\u0011\u0011|7-^7f]RT1!!\u0011\u0003\u0003\u0015iw\u000eZ3m\u0013\u0011\t)%a\u000f\u0003\u0011\t\u000b7/Z+oSRDq!!\u0013\u0001\t\u0013\tI#A\u0004d_6\u0004\u0018\u000e\\3\t\u000f\u00055\u0003\u0001\"\u0001\u0002P\u0005\u0001\u0012-\u001e;pI\u0016$Xm\u0019;Ts:$\u0018\r\u001f\u000b\u0004m\u0005E\u0003\u0002CA*\u0003\u0017\u0002\r!!\u0016\u0002\rM$(/Z1n!\u0011\t9&!\u0019\u000e\u0005\u0005e#\u0002BA.\u0003;\nA\u0001\\1oO*\u0011\u0011qL\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002d\u0005e#\u0001D\"iCJ\u001cV-];f]\u000e,\u0007bBA4\u0001\u0011%\u0011\u0011N\u0001\fa\u0006\u00148/Z*z]R\f\u0007\u0010\u0006\u0003\u0002l\u0005=\u0005\u0003CA7\u0003o\ni(!#\u000f\t\u0005=\u00141\u000f\b\u0004)\u0005E\u0014\"A\u0006\n\u0007\u0005U$\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00141\u0010\u0002\u0007\u000b&$\b.\u001a:\u000b\u0007\u0005U$\u0002\u0005\u0003\u0002\u0000\u0005\u0015UBAAA\u0015\ry\u00121\u0011\u0006\u0003Y\u0012IA!a\"\u0002\u0002\n91i\u001c8uK:$\bcA;\u0002\f&\u0019\u0011Q\u0012\u0002\u0003\tI{w\u000e\u001e\u0005\t\u0003#\u000b)\u00071\u0001\u0002~\u0005)\u0011N\u001c9vi\"9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0015!\u00069beN,W\t\u001f;fe:\fGN\u0012:bO6,g\u000e\u001e\u000b\u0005\u0003W\tI\n\u0003\u0005\u0002\u001c\u0006M\u0005\u0019AA?\u0003\u001d\u0019wN\u001c;f]RDq!a(\u0001\t\u0013\t\t+A\u0006qCJ\u001cX\rR8nC&tG\u0003BA\u0016\u0003GC\u0001\"!*\u0002\u001e\u0002\u0007\u00111N\u0001\u0007a\u0006\u00148/\u001a3\t\u000f\u0005}\u0005\u0001\"\u0003\u0002*R!\u00111FAV\u0011!\ti$a*A\u0002\u0005%\u0005bBAX\u0001\u0011%\u0011\u0011W\u0001\u0010a\u0006\u00148/\u001a*fM\u0016\u0014XM\\2fgR1\u00111WA[\u0003s\u0003b!!\f\u00024\u0005%\u0005\u0002CA\\\u0003[\u0003\r!!#\u0002\tI|w\u000e\u001e\u0005\t\u0003w\u000bi\u000b1\u0001\u0002>\u0006aAm\\7bS:\u0004F.^4j]B!\u0011qXAc\u001b\t\t\tM\u0003\u0003\u0002D\u0006\r\u0015a\u00029mk\u001eLgn]\u0005\u0005\u0003\u000f\f\tMA\tB\u001b\u001a#unY;nK:$\b\u000b\\;hS:Dq!a3\u0001\t\u0013\ti-A\u0004sKN|GN^3\u0015\u0005\u0005=\u0007CBA\u0017\u0003g\ti\bC\u0004\u0002T\u0002!I!!6\u0002)Y,'/\u001b4z\u001b\u0006$8\r[5oOZ+g\u000eZ8s)\u0019\t9.!8\u0002jB\u0019\u0011\"!7\n\u0007\u0005m'B\u0001\u0003V]&$\b\u0002CAp\u0003#\u0004\r!!9\u0002\u0013I,gMV3oI>\u0014\b\u0003B\u0005-\u0003G\u00042AIAs\u0013\r\t9o\t\u0002\u0007-\u0016tGm\u001c:\t\u0011\u0005-\u0018\u0011\u001ba\u0001\u0003[\fQA\\8eKN\u0004b!!\u001c\u0002p\u0006M\u0018\u0002BAy\u0003w\u00121aU3r!\u0011\t)P!\u0001\u000e\u0005\u0005](\u0002BA!\u0003sTA!a?\u0002~\u0006!\u00110Y7m\u0015\t\ty0A\u0002pe\u001eLAAa\u0001\u0002x\n)\u0011LT8eK\"9!q\u0001\u0001\u0005\u0002\t%\u0011a\u0005<fe&4\u0017PV1mS\u00124%/Y4nK:$HCBAl\u0005\u0017\u0011i\u0001\u0003\u0005\u0002`\n\u0015\u0001\u0019AAq\u0011!\u0011yA!\u0002A\u0002\tE\u0011\u0001\u0002:fMN\u0004b!!\u001c\u0002p\nM\u0001cA!\u0003\u0016%\u0019!q\u0003\"\u0003\u0019I+gmQ8oi\u0006Lg.\u001a:\t\u000f\u0005]\u0006\u0001\"\u0001\u0003\u001cQ\u0011\u00111W\u0004\b\u0005?\u0011\u0001\u0012\u0001B\u0011\u0003-\tUJR\"p[BLG.\u001a:\u0011\u0007U\u0014\u0019C\u0002\u0004\u0002\u0005!\u0005!QE\n\u0004\u0005GA\u0001b\u0002:\u0003$\u0011\u0005!\u0011\u0006\u000b\u0003\u0005CA\u0001B!\f\u0003$\u0011\u0005!qF\u0001\u0005S:LG\u000f\u0006\u0002\u0002X\"Q!1\u0007B\u0012#\u0003%\tA!\u000e\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u00119DK\u0002A\u0005sY#Aa\u000f\u0011\t\tu\"qI\u0007\u0003\u0005\u007fQAA!\u0011\u0003D\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u000bR\u0011AC1o]>$\u0018\r^5p]&!!\u0011\nB \u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0005\u001b\u0012\u0019#%A\u0005\u0002\t=\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0003R)\u001a1K!\u000f\t\u0015\tU#1EI\u0001\n\u0003\u00119&A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%O\u000b\u0003\u00053R3\u0001\u0018B\u001d\u0011)\u0011iFa\t\u0012\u0002\u0013\u0005!qL\u0001\u001dI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u00191+\t\u0011\tGK\u0002j\u0005s\u0001")
public class AMFCompiler {
    private final String rawUrl;
    private final Platform remote;
    private final Option<Context> base;
    private final Option<String> mediaType;
    private final Option<String> vendor;
    private final ReferenceKind referenceKind;
    private final Cache cache;
    private final Option<ParserContext> baseContext;
    private final Environment env;
    private final ParsingOptions parsingOptions;
    private final String path;
    private final Context context;
    private final String location;
    private final ParserContext ctx;

    public static ParsingOptions $lessinit$greater$default$10() {
        return AMFCompiler$.MODULE$.$lessinit$greater$default$10();
    }

    public static Environment $lessinit$greater$default$9() {
        return AMFCompiler$.MODULE$.$lessinit$greater$default$9();
    }

    public static Option<ParserContext> $lessinit$greater$default$8() {
        return AMFCompiler$.MODULE$.$lessinit$greater$default$8();
    }

    public static ReferenceKind $lessinit$greater$default$6() {
        return AMFCompiler$.MODULE$.$lessinit$greater$default$6();
    }

    public static void init() {
        AMFCompiler$.MODULE$.init();
    }

    public String rawUrl() {
        return this.rawUrl;
    }

    public Platform remote() {
        return this.remote;
    }

    public Option<Context> base() {
        return this.base;
    }

    public Option<String> mediaType() {
        return this.mediaType;
    }

    public Option<String> vendor() {
        return this.vendor;
    }

    public ReferenceKind referenceKind() {
        return this.referenceKind;
    }

    private Cache cache() {
        return this.cache;
    }

    private Option<ParserContext> baseContext() {
        return this.baseContext;
    }

    public Environment env() {
        return this.env;
    }

    public ParsingOptions parsingOptions() {
        return this.parsingOptions;
    }

    public String path() {
        return this.path;
    }

    private Context context() {
        return this.context;
    }

    private String location() {
        return this.location;
    }

    private ParserContext ctx() {
        return this.ctx;
    }

    public Future<BaseUnit> build() {
        ExecutionLog$.MODULE$.log(new StringBuilder(28).append("AMFCompiler#build: Building ").append(this.rawUrl()).toString());
        return this.context().hasCycles() ? Future$.MODULE$.failed((Throwable)new CyclicReferenceException(this.context().history())) : this.cache().getOrUpdate(this.location(), (Function0<Future<BaseUnit>>)(Function0 & Serializable & scala.Serializable)() -> {
            ExecutionLog$.MODULE$.log(new StringBuilder(29).append("AMFCompiler#build: compiling ").append(this.rawUrl()).toString());
            return this.compile();
        });
    }

    private Future<BaseUnit> compile() {
        return this.resolve().map((Function1 & Serializable & scala.Serializable)input -> this.parseSyntax((Content)input), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)parsed -> this.parseDomain((Either<Content, Root>)parsed), ExecutionContext.Implicits$.MODULE$.global());
    }

    public Option<String> autodetectSyntax(CharSequence stream) {
        Option option;
        if (stream.length() > 2 && stream.charAt(0) == '#' && stream.charAt(1) == '%') {
            ExecutionLog$.MODULE$.log("AMFCompiler#autodetectSyntax: auto detected application/yaml media type");
            option = new Some((Object)"application/yaml");
        } else {
            option = this.base().flatMap((Function1 & Serializable & scala.Serializable)b -> {
                None$ none$;
                Some some;
                char c2;
                Option<Object> option = b.platform().findCharInCharSequence(stream, (Function1<Object, Object>)(Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)AMFCompiler.$anonfun$autodetectSyntax$2(BoxesRunTime.unboxToChar((Object)c))));
                if (option instanceof Some && ((c2 = BoxesRunTime.unboxToChar((Object)(some = (Some)option).value())) == '{' || c2 == '[')) {
                    ExecutionLog$.MODULE$.log("AMFCompiler#autodetectSyntax: auto detected application/json media type");
                    none$ = new Some((Object)"application/json");
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            });
        }
        return option;
    }

    private Either<Content, Root> parseSyntax(Content input) {
        Left left;
        Some some;
        Tuple2 tuple2;
        Option parsed;
        ExecutionLog$.MODULE$.log(new StringBuilder(40).append("AMFCompiler#parseSyntax: parsing syntax ").append(this.rawUrl()).toString());
        Content content = (Content)AMFPluginsRegistry$.MODULE$.featurePlugins().foldLeft((Object)input, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Content c = (Content)tuple2._1();
            AMFFeaturePlugin p = (AMFFeaturePlugin)tuple2._2();
            Content content = p.onBeginDocumentParsing(this.path(), c, this.referenceKind());
            return content;
        });
        Option option = parsed = this.mediaType().flatMap((Function1 & Serializable & scala.Serializable)mime -> AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType((String)mime).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.parse((String)mime, content.stream(), this.ctx(), this.parsingOptions())).map((Function1 & Serializable & scala.Serializable)x$3 -> new Tuple2(mime, x$3))).orElse((Function0 & Serializable & scala.Serializable)() -> {
            Option<String> option = this.mediaType();
            Object object = None$.MODULE$.equals(option) ? content.mime().flatMap((Function1 & Serializable & scala.Serializable)mime -> AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType((String)mime).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.parse((String)mime, content.stream(), this.ctx(), this.parsingOptions())).map((Function1 & Serializable & scala.Serializable)x$5 -> new Tuple2(mime, x$5))).orElse((Function0 & Serializable & scala.Serializable)() -> FileMediaType$.MODULE$.extension(content.url()).flatMap((Function1 & Serializable & scala.Serializable)extension -> FileMediaType$.MODULE$.mimeFromExtension((String)extension)).flatMap((Function1 & Serializable & scala.Serializable)infered -> AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType((String)infered).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.parse((String)infered, content.stream(), this.ctx(), this.parsingOptions())).map((Function1 & Serializable & scala.Serializable)x$7 -> new Tuple2(infered, x$7)))).orElse((Function0 & Serializable & scala.Serializable)() -> this.autodetectSyntax(content.stream()).flatMap((Function1 & Serializable & scala.Serializable)infered -> AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType((String)infered).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.parse((String)infered, content.stream(), this.ctx(), this.parsingOptions())).map((Function1 & Serializable & scala.Serializable)x$9 -> new Tuple2(infered, x$9)))) : None$.MODULE$;
            return object;
        });
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String effective = (String)tuple2._1();
            ParsedDocument document = (ParsedDocument)tuple2._2();
            ParsedDocument doc = (ParsedDocument)AMFPluginsRegistry$.MODULE$.featurePlugins().foldLeft((Object)document, (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
                Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ParsedDocument d = (ParsedDocument)tuple2._1();
                AMFFeaturePlugin p = (AMFFeaturePlugin)tuple2._2();
                ParsedDocument parsedDocument = p.onSyntaxParsed(this.path(), d);
                return parsedDocument;
            });
            left = scala.package$.MODULE$.Right().apply((Object)Root$.MODULE$.apply(doc, content.url(), effective, (Seq<ParsedReference>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.referenceKind(), content.stream().toString()));
        } else if (None$.MODULE$.equals(option)) {
            left = scala.package$.MODULE$.Left().apply((Object)content);
        } else {
            throw new MatchError((Object)option);
        }
        return left;
    }

    public Future<BaseUnit> parseExternalFragment(Content content) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ExternalDomainElement result = ((ExternalDomainElement)ExternalDomainElement$.MODULE$.apply().withId(new StringBuilder(2).append(content.url()).append("#/").toString())).withRaw(content.stream().toString());
            content.mime().foreach((Function1 & Serializable & scala.Serializable)mime -> result.withMediaType((String)mime));
            return (ExternalFragment)((BaseUnit)((Object)((EncodesModel)ExternalFragment$.MODULE$.apply().withLocation(content.url()).withId(content.url())).withEncodes(result))).withLocation(content.url());
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<BaseUnit> parseDomain(Either<Content, Root> parsed) {
        Future<BaseUnit> future;
        Either<Content, Root> either = parsed;
        if (either instanceof Left) {
            Left left = (Left)either;
            Content content = (Content)left.value();
            Option<String> option = this.mediaType();
            if (option instanceof Some) {
                Some some = (Some)option;
                String mime = (String)some.value();
                if (this.context().history().length() == 1) {
                    throw new UnsupportedMediaTypeException(mime);
                }
            }
            Future<BaseUnit> future2 = this.parseExternalFragment(content);
            future = future2;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Root document = (Root)right.value();
            future = this.parseDomain(document);
        } else {
            throw new MatchError(either);
        }
        return future;
    }

    private Future<BaseUnit> parseDomain(Root document) {
        Future future;
        ExecutionLog$.MODULE$.log(new StringBuilder(40).append("AMFCompiler#parseDomain: parsing domain ").append(this.rawUrl()).toString());
        int currentRun = this.ctx().parserCount();
        Option domainPluginOption = (Option)this.vendor().fold((Function0 & Serializable & scala.Serializable)() -> AMFPluginsRegistry$.MODULE$.documentPluginForMediaType(document.mediatype()).find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.canParse(document))), (Function1 & Serializable & scala.Serializable)x$11 -> AMFPluginsRegistry$.MODULE$.documentPluginForVendor((String)x$11).find((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.canParse(document))));
        boolean bl = false;
        Option option = null;
        Option option2 = domainPluginOption;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)some.value();
            ExecutionLog$.MODULE$.log(new StringBuilder(48).append("AMFCompiler#parseSyntax: parsing domain ").append(this.rawUrl()).append(" plugin ").append(domainPlugin.ID()).toString());
            future = this.parseReferences(document, domainPlugin).map((Function1 & Serializable & scala.Serializable)documentWithReferences -> {
                BaseUnit baseUnit;
                ParserContext newCtx = this.ctx().copyWithSonsReferences();
                Option<BaseUnit> option = domainPlugin.parse((Root)documentWithReferences, newCtx, this.remote(), this.parsingOptions());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    BaseUnit baseUnit2 = (BaseUnit)some.value();
                    baseUnit = baseUnit2.withRaw(document.raw());
                } else if (None$.MODULE$.equals(option)) {
                    baseUnit = (BaseUnit)((Object)((EncodesModel)((Object)((BaseUnit)ExternalFragment$.MODULE$.apply().withId(document.location())).withLocation(document.location()))).withEncodes(ExternalDomainElement$.MODULE$.apply().withRaw(document.raw()).withMediaType(document.mediatype())));
                } else {
                    throw new MatchError(option);
                }
                return baseUnit;
            }, ExecutionContext.Implicits$.MODULE$.global());
        } else {
            if (None$.MODULE$.equals(option2)) {
                bl = true;
                option = option2;
                if (this.vendor().isDefined()) {
                    throw new UnsupportedVendorException((String)this.vendor().get());
                }
            }
            if (bl) {
                future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    ExecutionLog$.MODULE$.log(new StringBuilder(50).append("AMFCompiler#parseSyntax: parsing domain ").append(this.rawUrl()).append(" NO PLUGIN").toString());
                    return (ExternalFragment)((EncodesModel)ExternalFragment$.MODULE$.apply().withLocation(document.location()).withId(document.location())).withEncodes(ExternalDomainElement$.MODULE$.apply().withRaw(document.raw()).withMediaType(document.mediatype()));
                }, ExecutionContext.Implicits$.MODULE$.global());
            } else {
                throw new MatchError((Object)option2);
            }
        }
        Future futureDocument = future;
        return futureDocument.map((Function1 & Serializable & scala.Serializable)baseUnit -> {
            baseUnit.parserRun_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)currentRun)));
            ExecutionLog$.MODULE$.log(new StringBuilder(37).append("AMFCompiler#parseDomain: model ready ").append(this.rawUrl()).toString());
            return (BaseUnit)AMFPluginsRegistry$.MODULE$.featurePlugins().foldLeft(baseUnit, (Function2 & Serializable & scala.Serializable)(x0$3, x1$3) -> {
                Tuple2 tuple2 = new Tuple2(x0$3, x1$3);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                BaseUnit unit = (BaseUnit)tuple2._1();
                AMFFeaturePlugin plugin = (AMFFeaturePlugin)tuple2._2();
                BaseUnit baseUnit = plugin.onModelParsed(this.path(), unit);
                return baseUnit;
            });
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<Root> parseReferences(Root root, AMFDocumentPlugin domainPlugin) {
        ReferenceHandler handler = domainPlugin.referenceHandler(this.ctx());
        ReferenceCollector refs = handler.collect(root.parsed(), this.ctx());
        ExecutionLog$.MODULE$.log(new StringBuilder(50).append("AMFCompiler#parseReferences: ").append(refs.toReferences().size()).append(" references found in ").append(this.rawUrl()).toString());
        Seq parsed = (Seq)((TraversableLike)refs.toReferences().filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isRemote()))).map((Function1 & Serializable & scala.Serializable)link -> {
            Seq nodes = (Seq)link.refs().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.node(), Seq$.MODULE$.canBuildFrom());
            return link.resolve(this.context(), this.cache(), this.ctx(), this.env(), (Seq<YNode>)nodes, domainPlugin.allowRecursiveReferences()).flatMap(arg_0 -> AMFCompiler.$anonfun$parseReferences$4(this, domainPlugin, handler, nodes, link, arg_0), ExecutionContext.Implicits$.MODULE$.global());
        }, Seq$.MODULE$.canBuildFrom());
        return Future$.MODULE$.sequence((TraversableOnce)parsed, Seq$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)rs -> {
            Seq x$18 = (Seq)rs.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
            ParsedDocument x$19 = root.copy$default$1();
            String x$20 = root.copy$default$2();
            String x$21 = root.copy$default$3();
            ReferenceKind x$22 = root.copy$default$5();
            String x$23 = root.copy$default$6();
            return root.copy(x$19, x$20, x$21, (Seq<ParsedReference>)x$18, x$22, x$23);
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<Content> resolve() {
        return this.remote().resolve(this.location(), this.env());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void verifyMatchingVendor(Option<Vendor> refVendor, Seq<YNode> nodes) {
        Option<Vendor> option = refVendor;
        if (option instanceof Some) {
            Some some = (Some)option;
            Vendor v = (Vendor)some.value();
            if (this.vendor().nonEmpty() && !v.name().contains((CharSequence)this.vendor().get())) {
                nodes.foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
                    AMFCompiler.$anonfun$verifyMatchingVendor$1(this, x$16);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void verifyValidFragment(Option<Vendor> refVendor, Seq<RefContainer> refs) {
        Some some;
        Vendor v;
        Option<Vendor> option = refVendor;
        if (option instanceof Some && (v = (Vendor)(some = (Some)option).value()).isRaml()) {
            refs.foreach((Function1 & Serializable & scala.Serializable)r -> {
                AMFCompiler.$anonfun$verifyValidFragment$1(this, r);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Future<Root> root() {
        return this.resolve().map((Function1 & Serializable & scala.Serializable)input -> this.parseSyntax((Content)input), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Right right;
            Root document;
            Either either = x0$5;
            if (either instanceof Right && (document = (Root)(right = (Right)either).value()) != null) {
                Future future;
                Root root = document;
                Option option = AMFPluginsRegistry$.MODULE$.documentPluginForMediaType(root.mediatype()).find((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.canParse(root)));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)some.value();
                    future = this.parseReferences(root, domainPlugin);
                    return future;
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> root, ExecutionContext.Implicits$.MODULE$.global());
                }
                return future;
            }
            if (!(either instanceof Left)) throw new MatchError((Object)either);
            Left left = (Left)either;
            Content content = (Content)left.value();
            throw new Exception(new StringBuilder(37).append("Cannot parse document with mime type ").append(content.mime().getOrElse((Function0 & Serializable & scala.Serializable)() -> "none")).toString());
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private final String liftedTree1$1() {
        String string;
        try {
            string = package$.MODULE$.Strings(this.rawUrl()).normalizePath();
        }
        catch (URISyntaxException e) {
            ((ErrorHandler)this.baseContext().getOrElse((Function0 & Serializable & scala.Serializable)() -> new ParserContext(this.rawUrl(), ParserContext$.MODULE$.apply$default$2(), ParserContext$.MODULE$.apply$default$3(), ParserContext$.MODULE$.apply$default$4(), ParserContext$.MODULE$.apply$default$5()))).violation(ParserSideValidations$.MODULE$.UriSyntaxError(), this.path(), e.getMessage(), (YPart)YNode$.MODULE$.apply(this.path()));
            string = this.rawUrl();
        }
        catch (Exception e) {
            throw new PathResolutionError(e.getMessage());
        }
        return string;
    }

    public static final /* synthetic */ Context $anonfun$context$1(AMFCompiler $this, Context x$1) {
        return x$1.update($this.path());
    }

    public static final /* synthetic */ Context $anonfun$context$2(AMFCompiler $this) {
        return Context$.MODULE$.apply($this.remote(), $this.path());
    }

    public static final /* synthetic */ boolean $anonfun$autodetectSyntax$2(char c) {
        return c != '\n' && c != '\t' && c != '\r' && c != ' ';
    }

    public static final /* synthetic */ Some $anonfun$parseReferences$5(ParsedReference x$15) {
        return new Some((Object)x$15);
    }

    public static final /* synthetic */ None$ $anonfun$parseReferences$6() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$parseReferences$7(AMFCompiler $this, Throwable e$1, Reference link$1, YNode ref) {
        $this.ctx().violation(ParserSideValidations$.MODULE$.UnresolvedReference(), link$1.url(), e$1.getMessage(), (YPart)ref);
    }

    public static final /* synthetic */ None$ $anonfun$parseReferences$8() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ None$ $anonfun$parseReferences$9() {
        return None$.MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Future $anonfun$parseReferences$4(AMFCompiler $this, AMFDocumentPlugin domainPlugin$2, ReferenceHandler handler$1, Seq nodes$1, Reference link$1, ReferenceResolutionResult x0$4) {
        block4: {
            block5: {
                block3: {
                    var8_6 = x0$4;
                    if (var8_6 == null || !((var9_7 = var8_6.unit()) instanceof Some)) break block3;
                    var10_8 = (Some)var9_7;
                    unit = (BaseUnit)var10_8.value();
                    $this.verifyMatchingVendor(unit.sourceVendor(), (Seq<YNode>)nodes$1);
                    $this.verifyValidFragment(unit.sourceVendor(), link$1.refs());
                    reference = new ParsedReference(unit, link$1, ParsedReference$.MODULE$.apply$default$3());
                    var6_11 = handler$1.update(reference, $this.ctx(), $this.context(), $this.env(), $this.cache()).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseReferences$5(amf.core.parser.ParsedReference ), (Lamf/core/parser/ParsedReference;)Lscala/Some;)(), ExecutionContext.Implicits$.MODULE$.global());
                    break block4;
                }
                if (var8_6 == null || !((var13_12 = var8_6.exception()) instanceof Some)) break block5;
                var14_13 = (Some)var13_12;
                e = (Throwable)var14_13.value();
                var16_15 = e;
                if (!(var16_15 instanceof CyclicReferenceException)) ** GOTO lbl-1000
                var17_16 = (CyclicReferenceException)var16_15;
                if (!domainPlugin$2.allowRecursiveReferences()) {
                    $this.ctx().violation(ParserSideValidations$.MODULE$.CycleReferenceError(), link$1.url(), var17_16.getMessage(), (YPart)((RefContainer)link$1.refs().head()).node());
                    var7_17 = Future$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseReferences$6(), ()Lscala/None$;)(), ExecutionContext.Implicits$.MODULE$.global());
                } else lbl-1000:
                // 2 sources

                {
                    if (!link$1.isInferred()) {
                        nodes$1.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseReferences$7$adapted(amf.core.AMFCompiler java.lang.Throwable amf.core.parser.Reference org.yaml.model.YNode ), (Lorg/yaml/model/YNode;)Ljava/lang/Object;)((AMFCompiler)$this, (Throwable)e, (Reference)link$1));
                    }
                    var7_17 = Future$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseReferences$8(), ()Lscala/None$;)(), ExecutionContext.Implicits$.MODULE$.global());
                }
                var6_11 = var7_17;
                break block4;
            }
            var6_11 = Future$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseReferences$9(), ()Lscala/None$;)(), ExecutionContext.Implicits$.MODULE$.global());
        }
        return var6_11;
    }

    public static final /* synthetic */ void $anonfun$verifyMatchingVendor$1(AMFCompiler $this, YNode x$16) {
        $this.ctx().violation(ParserSideValidations$.MODULE$.InvalidCrossSpec(), "", "Cannot reference fragments of another spec", (YPart)x$16);
    }

    public static final /* synthetic */ void $anonfun$verifyValidFragment$1(AMFCompiler $this, RefContainer r) {
        block0: {
            if (!r.fragment().isDefined()) break block0;
            $this.ctx().violation(ParserSideValidations$.MODULE$.InvalidFragmentRef(), "", "Cannot use reference with # in a RAML fragment", (YPart)r.node());
        }
    }

    /*
     * Unable to fully structure code
     */
    public AMFCompiler(String rawUrl, Platform remote, Option<Context> base, Option<String> mediaType, Option<String> vendor, ReferenceKind referenceKind, Cache cache, Option<ParserContext> baseContext, Environment env, ParsingOptions parsingOptions) {
        this.rawUrl = rawUrl;
        this.remote = remote;
        this.base = base;
        this.mediaType = mediaType;
        this.vendor = vendor;
        this.referenceKind = referenceKind;
        this.cache = cache;
        this.baseContext = baseContext;
        this.env = env;
        this.parsingOptions = parsingOptions;
        super();
        this.path = this.liftedTree1$1();
        this.context = (Context)base.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$context$1(amf.core.AMFCompiler amf.core.remote.Context ), (Lamf/core/remote/Context;)Lamf/core/remote/Context;)((AMFCompiler)this)).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$context$2(amf.core.AMFCompiler ), ()Lamf/core/remote/Context;)((AMFCompiler)this));
        this.location = this.context().current();
        var12_11 = false;
        var13_12 = null;
        var14_13 = baseContext;
        if (!(var14_13 instanceof Some)) ** GOTO lbl-1000
        var12_11 = true;
        var13_12 = (Some)var14_13;
        given = (ParserContext)var13_12.value();
        if (given.rootContextDocument().equals(this.location())) {
            var11_15 = given;
        } else if (var12_11) {
            given = (ParserContext)var13_12.value();
            var11_15 = given.forLocation(this.location());
        } else if (None$.MODULE$.equals(var14_13)) {
            var11_15 = new ParserContext(this.location(), ParserContext$.MODULE$.apply$default$2(), ParserContext$.MODULE$.apply$default$3(), ParserContext$.MODULE$.apply$default$4(), ParserContext$.MODULE$.apply$default$5());
        } else {
            throw new MatchError(var14_13);
        }
        this.ctx = var11_15;
    }

    public static final /* synthetic */ Object $anonfun$parseReferences$7$adapted(AMFCompiler $this, Throwable e$1, Reference link$1, YNode ref) {
        AMFCompiler.$anonfun$parseReferences$7($this, e$1, link$1, ref);
        return BoxedUnit.UNIT;
    }
}

