/*
 * Decompiled with CFR 0.152.
 */
package amf.core;

import amf.client.plugins.AMFDocumentPlugin;
import amf.client.plugins.AMFSyntaxPlugin;
import amf.core.AMFSerializer$;
import amf.core.benchmark.ExecutionLog$;
import amf.core.emitter.RenderOptions;
import amf.core.model.document.BaseUnit;
import amf.core.model.document.ExternalFragment;
import amf.core.parser.SyamlParsedDocument;
import amf.core.parser.SyamlParsedDocument$;
import amf.core.rdf.RdfFramework;
import amf.core.rdf.RdfModelDocument;
import amf.core.registries.AMFPluginsRegistry$;
import amf.core.remote.Platform;
import amf.core.remote.Vendor$;
import amf.plugins.document.graph.AMFGraphPlugin$;
import amf.plugins.document.graph.parser.JsonLdEmitter$;
import amf.plugins.syntax.RdfSyntaxPlugin$;
import java.io.Serializable;
import java.io.StringWriter;
import org.mulesoft.common.io.Output;
import org.mulesoft.common.io.Output$;
import org.yaml.builder.DocBuilder;
import org.yaml.builder.JsonOutputBuilder;
import org.yaml.builder.JsonOutputBuilder$;
import org.yaml.builder.YDocumentBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\u0001\u0003\u0001\u001d\u0011Q\"Q'G'\u0016\u0014\u0018.\u00197ju\u0016\u0014(BA\u0002\u0005\u0003\u0011\u0019wN]3\u000b\u0003\u0015\t1!Y7g\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011!y\u0001A!A!\u0002\u0013\u0001\u0012\u0001B;oSR\u0004\"!\u0005\f\u000e\u0003IQ!a\u0005\u000b\u0002\u0011\u0011|7-^7f]RT!!\u0006\u0002\u0002\u000b5|G-\u001a7\n\u0005]\u0011\"\u0001\u0003\"bg\u0016,f.\u001b;\t\u0011e\u0001!\u0011!Q\u0001\ni\t\u0011\"\\3eS\u0006$\u0016\u0010]3\u0011\u0005m\u0011cB\u0001\u000f!!\ti\"\"D\u0001\u001f\u0015\tyb!\u0001\u0004=e>|GOP\u0005\u0003C)\ta\u0001\u0015:fI\u00164\u0017BA\u0012%\u0005\u0019\u0019FO]5oO*\u0011\u0011E\u0003\u0005\tM\u0001\u0011\t\u0011)A\u00055\u00051a/\u001a8e_JD\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!K\u0001\b_B$\u0018n\u001c8t!\tQS&D\u0001,\u0015\ta#!A\u0004f[&$H/\u001a:\n\u00059Z#!\u0004*f]\u0012,'o\u00149uS>t7\u000fC\u00031\u0001\u0011\u0005\u0011'\u0001\u0004=S:LGO\u0010\u000b\u0006eQ*dg\u000e\t\u0003g\u0001i\u0011A\u0001\u0005\u0006\u001f=\u0002\r\u0001\u0005\u0005\u00063=\u0002\rA\u0007\u0005\u0006M=\u0002\rA\u0007\u0005\u0006Q=\u0002\r!\u000b\u0005\u0006s\u0001!\tAO\u0001\u0012e\u0016tG-\u001a:Bgf#unY;nK:$H#A\u001e\u0011\u0005qzT\"A\u001f\u000b\u0005y\u0012\u0011A\u00029beN,'/\u0003\u0002A{\t\u00192+_1nYB\u000b'o]3e\t>\u001cW/\\3oi\")!\t\u0001C\u0001\u0007\u0006y!/\u001a8eKJ$vNQ;jY\u0012,'/\u0006\u0002ECR\u0011Q\t\u0016\u000b\u0003\r>\u00032a\u0012&M\u001b\u0005A%BA%\u000b\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\u0017\"\u0013aAR;ukJ,\u0007CA\u0005N\u0013\tq%B\u0001\u0003V]&$\b\"\u0002)B\u0001\b\t\u0016\u0001C3yK\u000e,Ho\u001c:\u0011\u0005\u001d\u0013\u0016BA*I\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u0003V\u0003\u0002\u0007a+A\u0004ck&dG-\u001a:\u0011\u0007]kv,D\u0001Y\u0015\t)\u0016L\u0003\u0002[7\u0006!\u00110Y7m\u0015\u0005a\u0016aA8sO&\u0011a\f\u0017\u0002\u000b\t>\u001c')^5mI\u0016\u0014\bC\u00011b\u0019\u0001!QAY!C\u0002\r\u0014\u0011\u0001V\t\u0003I\u001e\u0004\"!C3\n\u0005\u0019T!a\u0002(pi\"Lgn\u001a\t\u0003\u0013!L!!\u001b\u0006\u0003\u0007\u0005s\u0017\u0010C\u0003l\u0001\u0011\u0005A.\u0001\bsK:$WM\u001d+p/JLG/\u001a:\u0016\u00055dHC\u00018\u0000)\r1uN \u0005\ba*\f\t\u0011q\u0001r\u0003))g/\u001b3f]\u000e,G%\r\t\u0004ef\\X\"A:\u000b\u0005Q,\u0018AA5p\u0015\t1x/\u0001\u0004d_6lwN\u001c\u0006\u0003qn\u000b\u0001\"\\;mKN|g\r^\u0005\u0003uN\u0014aaT;uaV$\bC\u00011}\t\u0015i(N1\u0001d\u0005\u00059\u0006\"\u0002)k\u0001\b\t\u0006BBA\u0001U\u0002\u000710\u0001\u0004xe&$XM\u001d\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u00039\u0011XM\u001c3feR{7\u000b\u001e:j]\u001e$B!!\u0003\u0002\fA\u0019qI\u0013\u000e\t\rA\u000b\u0019\u0001q\u0001R\u0011\u001d\ty\u0001\u0001C\u0001\u0003#\tAB]3oI\u0016\u0014Hk\u001c$jY\u0016$b!a\u0005\u0002\u0018\u0005\u0015Bc\u0001$\u0002\u0016!1\u0001+!\u0004A\u0004EC\u0001\"!\u0007\u0002\u000e\u0001\u0007\u00111D\u0001\u0007e\u0016lw\u000e^3\u0011\t\u0005u\u0011\u0011E\u0007\u0003\u0003?Q1!!\u0007\u0003\u0013\u0011\t\u0019#a\b\u0003\u0011Ac\u0017\r\u001e4pe6Dq!a\n\u0002\u000e\u0001\u0007!$\u0001\u0003qCRD\u0007bBA\u0016\u0001\u0011%\u0011QF\u0001\u0007e\u0016tG-\u001a:\u0016\t\u0005=\u00121\b\u000b\u0005\u0003c\ti\u0004F\u0002M\u0003gA!\"!\u000e\u0002*\u0005\u0005\t9AA\u001c\u0003))g/\u001b3f]\u000e,GE\r\t\u0005ef\fI\u0004E\u0002a\u0003w!a!`A\u0015\u0005\u0004\u0019\u0007\u0002CA\u0001\u0003S\u0001\r!!\u000f\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D\u0005A\u0001/\u0019:tKJ#g-\u0006\u0003\u0002F\u0005EC\u0003BA$\u0003'\"2\u0001TA%\u0011)\tY%a\u0010\u0002\u0002\u0003\u000f\u0011QJ\u0001\u000bKZLG-\u001a8dK\u0012\u001a\u0004\u0003\u0002:z\u0003\u001f\u00022\u0001YA)\t\u0019i\u0018q\bb\u0001G\"A\u0011\u0011AA \u0001\u0004\ty\u0005C\u0004\u0002,\u0001!I!a\u0016\u0015\u0003iAq!a\u0017\u0001\t#\ti&\u0001\tgS:$Gi\\7bS:\u0004F.^4j]R\u0011\u0011q\f\t\u0006\u0013\u0005\u0005\u0014QM\u0005\u0004\u0003GR!AB(qi&|g\u000e\u0005\u0003\u0002h\u0005ETBAA5\u0015\u0011\tY'!\u001c\u0002\u000fAdWoZ5og*\u0019\u0011q\u000e\u0003\u0002\r\rd\u0017.\u001a8u\u0013\u0011\t\u0019(!\u001b\u0003#\u0005ke\tR8dk6,g\u000e\u001e)mk\u001eLg\u000eC\u0004\u0002x\u0001!I!!\u001f\u0002\u001f\u001d,G\u000fR8nC&t\u0007\u000b\\;hS:,\"!!\u001a\b\u000f\u0005u$\u0001#\u0001\u0002\u0000\u0005i\u0011)\u0014$TKJL\u0017\r\\5{KJ\u00042aMAA\r\u0019\t!\u0001#\u0001\u0002\u0004N\u0019\u0011\u0011\u0011\u0005\t\u000fA\n\t\t\"\u0001\u0002\bR\u0011\u0011q\u0010\u0005\t\u0003\u0017\u000b\t\t\"\u0001\u0002\u000e\u0006!\u0011N\\5u)\u0005a\u0005")
public class AMFSerializer {
    private final BaseUnit unit;
    private final String mediaType;
    private final String vendor;
    private final RenderOptions options;

    public static void init() {
        AMFSerializer$.MODULE$.init();
    }

    public SyamlParsedDocument renderAsYDocument() {
        YDocumentBuilder builder;
        AMFDocumentPlugin domainPlugin = this.getDomainPlugin();
        if (!domainPlugin.emit(this.unit, builder = new YDocumentBuilder(), this.options)) {
            throw new Exception(new StringBuilder(43).append("Error unparsing syntax ").append(this.mediaType).append(" with domain plugin ").append(domainPlugin.ID()).toString());
        }
        return new SyamlParsedDocument(builder.result(), SyamlParsedDocument$.MODULE$.apply$default$2());
    }

    public <T> Future<BoxedUnit> renderToBuilder(DocBuilder<T> builder, ExecutionContext executor) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                String string = $this.vendor;
                String string2 = Vendor$.MODULE$.AMF().name();
                if (string != null ? !string.equals(string2) : string2 != null) break block0;
                JsonLdEmitter$.MODULE$.emit($this.unit, builder, $this.options);
            }
        }, executor);
    }

    public <W> Future<BoxedUnit> renderToWriter(W writer, Output<W> evidence$1, ExecutionContext executor) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.render(writer, evidence$1), executor);
    }

    public Future<String> renderToString(ExecutionContext executor) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.amf$core$AMFSerializer$$render(), executor);
    }

    public Future<BoxedUnit> renderToFile(Platform remote, String path, ExecutionContext executor) {
        return this.renderToString(executor).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            remote.write(path, x$1);
            return BoxedUnit.UNIT;
        }, executor);
    }

    private <W> void render(W writer, Output<W> evidence$2) {
        ExecutionLog$.MODULE$.log(new StringBuilder(44).append("AMFSerializer#render: Rendering to ").append(this.mediaType).append(" (").append(this.vendor).append(" file) ").append(this.unit.location()).toString());
        String string = this.vendor;
        String string2 = Vendor$.MODULE$.AMF().name();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Object object;
            if (!this.options.isAmfJsonLdSerilization()) {
                this.parseRdf(writer, evidence$2);
                object = BoxedUnit.UNIT;
            } else {
                JsonOutputBuilder b = JsonOutputBuilder$.MODULE$.apply(writer, JsonOutputBuilder$.MODULE$.apply$default$2(), evidence$2);
                object = BoxesRunTime.boxToBoolean((boolean)JsonLdEmitter$.MODULE$.emit(this.unit, b, this.options));
            }
            return;
        }
        SyamlParsedDocument ast = this.renderAsYDocument();
        Option<AMFSyntaxPlugin> option = AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType(this.mediaType);
        if (option instanceof Some) {
            Some some = (Some)option;
            AMFSyntaxPlugin syntaxPlugin = (AMFSyntaxPlugin)some.value();
            syntaxPlugin.unparse(this.mediaType, ast, writer, evidence$2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option) && this.unit instanceof ExternalFragment) {
            Output$.MODULE$.OutputOps(writer).append((CharSequence)((ExternalFragment)this.unit).encodes().raw().value(), evidence$2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new Exception(new StringBuilder(35).append("Unsupported media type ").append(this.mediaType).append(" and vendor ").append(this.vendor).toString());
        }
    }

    private <W> void parseRdf(W writer, Output<W> evidence$3) {
        Option<RdfFramework> option = AMFGraphPlugin$.MODULE$.platform().rdfFramework();
        if (option instanceof Some) {
            Some some = (Some)option;
            RdfFramework r = (RdfFramework)some.value();
            RdfModelDocument d = new RdfModelDocument(r.unitToRdfModel(this.unit, this.options));
            RdfSyntaxPlugin$.MODULE$.unparse(this.mediaType, d, writer, evidence$3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public String amf$core$AMFSerializer$$render() {
        StringWriter w = new StringWriter();
        this.render(w, Output$.MODULE$.outputWriter());
        return w.toString();
    }

    public Option<AMFDocumentPlugin> findDomainPlugin() {
        Some some;
        Option option = AMFPluginsRegistry$.MODULE$.documentPluginForVendor(this.vendor).find((Function1 & Serializable & scala.Serializable)plugin -> BoxesRunTime.boxToBoolean((boolean)AMFSerializer.$anonfun$findDomainPlugin$1(this, plugin)));
        if (option instanceof Some) {
            Some some2 = (Some)option;
            AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)some2.value();
            some = new Some((Object)domainPlugin);
        } else if (None$.MODULE$.equals(option)) {
            some = AMFPluginsRegistry$.MODULE$.documentPluginForMediaType(this.mediaType).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.canUnparse(this.unit)));
        } else {
            throw new MatchError((Object)option);
        }
        return some;
    }

    private AMFDocumentPlugin getDomainPlugin() {
        return (AMFDocumentPlugin)this.findDomainPlugin().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception(new StringBuilder(69).append("Cannot serialize domain model '").append($this.unit.location()).append("' for detected media type ").append($this.mediaType).append(" and vendor ").append($this.vendor).toString());
        });
    }

    public static final /* synthetic */ boolean $anonfun$findDomainPlugin$1(AMFSerializer $this, AMFDocumentPlugin plugin) {
        return plugin.documentSyntaxes().contains((Object)$this.mediaType) && plugin.canUnparse($this.unit);
    }

    public AMFSerializer(BaseUnit unit, String mediaType, String vendor, RenderOptions options) {
        this.unit = unit;
        this.mediaType = mediaType;
        this.vendor = vendor;
        this.options = options;
    }
}

