/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public final class StringUtils {
    private static final String HEX_CHARACTERS = "0123456789abcdef";
    private static final String HEX_CHARACTERS_UC = "0123456789abcdef".toUpperCase();
    private static final ThreadLocal<StringBuilder> STRING_BUILDERS = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder(512);
        }
    };

    public static StringBuilder stringBuilder() {
        StringBuilder sb = STRING_BUILDERS.get();
        sb.setLength(0);
        return sb;
    }

    private StringUtils() {
    }

    public static ByteBuffer charSequence2ByteBuffer(CharSequence cs, Charset charset) {
        return charset.encode(CharBuffer.wrap(cs));
    }

    public static byte[] byteBuffer2ByteArray(ByteBuffer bb) {
        byte[] rawBase = new byte[bb.remaining()];
        bb.get(rawBase);
        return rawBase;
    }

    public static byte[] charSequence2Bytes(CharSequence sb, Charset charset) {
        ByteBuffer bb = StringUtils.charSequence2ByteBuffer(sb, charset);
        return StringUtils.byteBuffer2ByteArray(bb);
    }

    public static String toHexString(byte[] bytes) {
        return StringUtils.toHexString(bytes, false);
    }

    public static String toHexString(byte[] bytes, boolean uppercase) {
        if (bytes == null) {
            return null;
        }
        int numBytes = bytes.length;
        StringBuilder str = new StringBuilder(numBytes * 2);
        String table = uppercase ? HEX_CHARACTERS_UC : HEX_CHARACTERS;
        for (int i = 0; i < numBytes; ++i) {
            str.append(table.charAt(bytes[i] >>> 4 & 0xF));
            str.append(table.charAt(bytes[i] & 0xF));
        }
        return str.toString();
    }
}

