/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.util.MiscUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FluentCaseInsensitiveStringsMap
implements Map<String, List<String>>,
Iterable<Map.Entry<String, List<String>>> {
    private final Map<String, List<String>> values = new LinkedHashMap<String, List<String>>();
    private final Map<String, String> keyLookup = new LinkedHashMap<String, String>();

    public FluentCaseInsensitiveStringsMap() {
    }

    public FluentCaseInsensitiveStringsMap(FluentCaseInsensitiveStringsMap src) {
        if (src != null) {
            for (Map.Entry<String, List<String>> header : src) {
                this.add(header.getKey(), (Collection<String>)header.getValue());
            }
        }
    }

    public FluentCaseInsensitiveStringsMap(Map<String, Collection<String>> src) {
        if (src != null) {
            for (Map.Entry<String, Collection<String>> header : src.entrySet()) {
                this.add(header.getKey(), header.getValue());
            }
        }
    }

    public FluentCaseInsensitiveStringsMap add(String key, String value) {
        if (key != null) {
            String lcKey = key.toLowerCase(Locale.ENGLISH);
            String realKey = this.keyLookup.get(lcKey);
            List<String> curValues = null;
            if (realKey == null) {
                this.keyLookup.put(lcKey, key);
                curValues = new ArrayList<String>();
                this.values.put(key, curValues);
            } else {
                curValues = this.values.get(realKey);
            }
            String nonNullValue = value != null ? value : "";
            curValues.add(nonNullValue);
        }
        return this;
    }

    public FluentCaseInsensitiveStringsMap add(String key, String ... values) {
        if (MiscUtils.isNonEmpty(values)) {
            this.add(key, Arrays.asList(values));
        }
        return this;
    }

    private List<String> fetchValues(Collection<String> values) {
        ArrayList<String> result = null;
        if (values != null) {
            for (String value : values) {
                if (value == null) {
                    value = "";
                }
                if (result == null) {
                    result = new ArrayList<String>();
                }
                result.add(value);
            }
        }
        return result;
    }

    public FluentCaseInsensitiveStringsMap add(String key, Collection<String> values) {
        List<String> nonNullValues;
        if (key != null && (nonNullValues = this.fetchValues(values)) != null) {
            String lcKey = key.toLowerCase(Locale.ENGLISH);
            String realKey = this.keyLookup.get(lcKey);
            List<String> curValues = null;
            if (realKey == null) {
                realKey = key;
                this.keyLookup.put(lcKey, key);
            } else {
                curValues = this.values.get(realKey);
            }
            if (curValues == null) {
                curValues = new ArrayList<String>();
                this.values.put(realKey, curValues);
            }
            curValues.addAll(nonNullValues);
        }
        return this;
    }

    public FluentCaseInsensitiveStringsMap addAll(FluentCaseInsensitiveStringsMap src) {
        if (src != null) {
            for (Map.Entry<String, List<String>> header : src) {
                this.add(header.getKey(), (Collection<String>)header.getValue());
            }
        }
        return this;
    }

    public FluentCaseInsensitiveStringsMap addAll(Map<String, Collection<String>> src) {
        if (src != null) {
            for (Map.Entry<String, Collection<String>> header : src.entrySet()) {
                this.add(header.getKey(), header.getValue());
            }
        }
        return this;
    }

    public FluentCaseInsensitiveStringsMap replaceWith(String key, String ... values) {
        return this.replaceWith(key, Arrays.asList(values));
    }

    public FluentCaseInsensitiveStringsMap replaceWith(String key, Collection<String> values) {
        if (key != null) {
            List<String> nonNullValues = this.fetchValues(values);
            String lcKkey = key.toLowerCase(Locale.ENGLISH);
            String realKey = this.keyLookup.get(lcKkey);
            if (nonNullValues == null) {
                this.keyLookup.remove(lcKkey);
                if (realKey != null) {
                    this.values.remove(realKey);
                }
            } else {
                if (!key.equals(realKey)) {
                    this.keyLookup.put(lcKkey, key);
                    this.values.remove(realKey);
                }
                this.values.put(key, nonNullValues);
            }
        }
        return this;
    }

    public FluentCaseInsensitiveStringsMap replaceAll(FluentCaseInsensitiveStringsMap src) {
        if (src != null) {
            for (Map.Entry<String, List<String>> header : src) {
                this.replaceWith(header.getKey(), (Collection<String>)header.getValue());
            }
        }
        return this;
    }

    public FluentCaseInsensitiveStringsMap replaceAll(Map<? extends String, ? extends Collection<String>> src) {
        if (src != null) {
            for (Map.Entry<? extends String, ? extends Collection<String>> header : src.entrySet()) {
                this.replaceWith(header.getKey(), header.getValue());
            }
        }
        return this;
    }

    @Override
    public List<String> put(String key, List<String> value) {
        if (key == null) {
            throw new NullPointerException("Null keys are not allowed");
        }
        Object oldValue = this.get(key);
        this.replaceWith(key, value);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> values) {
        this.replaceAll(values);
    }

    public FluentCaseInsensitiveStringsMap delete(String key) {
        String lcKey;
        String realKey;
        if (key != null && (realKey = this.keyLookup.remove(lcKey = key.toLowerCase(Locale.ENGLISH))) != null) {
            this.values.remove(realKey);
        }
        return this;
    }

    public FluentCaseInsensitiveStringsMap deleteAll(String ... keys) {
        if (keys != null) {
            for (String key : keys) {
                this.remove(key);
            }
        }
        return this;
    }

    public FluentCaseInsensitiveStringsMap deleteAll(Collection<String> keys) {
        if (keys != null) {
            for (String key : keys) {
                this.remove(key);
            }
        }
        return this;
    }

    @Override
    public List<String> remove(Object key) {
        if (key == null) {
            return null;
        }
        Object oldValues = this.get(key.toString());
        this.delete(key.toString());
        return oldValues;
    }

    @Override
    public void clear() {
        this.keyLookup.clear();
        this.values.clear();
    }

    @Override
    public Iterator<Map.Entry<String, List<String>>> iterator() {
        return Collections.unmodifiableSet(this.values.entrySet()).iterator();
    }

    @Override
    public Set<String> keySet() {
        return new LinkedHashSet<String>(this.keyLookup.values());
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.values.entrySet();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return key == null ? false : this.keyLookup.containsKey(key.toString().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    public String getFirstValue(String key) {
        Object values = this.get(key);
        if (values.isEmpty()) {
            return null;
        }
        return (String)values.get(0);
    }

    public String getJoinedValue(String key, String delimiter) {
        Object values = this.get(key);
        if (values.isEmpty()) {
            return null;
        }
        if (values.size() == 1) {
            return (String)values.get(0);
        }
        StringBuilder result = new StringBuilder();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            String value = (String)iterator.next();
            if (result.length() > 0) {
                result.append(delimiter);
            }
            result.append(value);
        }
        return result.toString();
    }

    @Override
    public List<String> get(Object key) {
        if (key == null) {
            return Collections.emptyList();
        }
        String lcKey = key.toString().toLowerCase(Locale.ENGLISH);
        String realKey = this.keyLookup.get(lcKey);
        return realKey != null ? this.values.get(realKey) : Collections.emptyList();
    }

    @Override
    public Collection<List<String>> values() {
        return this.values.values();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FluentCaseInsensitiveStringsMap other = (FluentCaseInsensitiveStringsMap)obj;
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    @Override
    public int hashCode() {
        return this.values == null ? 0 : this.values.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.values.entrySet()) {
            if (result.length() > 0) {
                result.append("; ");
            }
            result.append("\"");
            result.append(entry.getKey());
            result.append("=");
            boolean needsComma = false;
            for (String value : entry.getValue()) {
                if (needsComma) {
                    result.append(", ");
                } else {
                    needsComma = true;
                }
                result.append(value);
            }
            result.append("\"");
        }
        return result.toString();
    }
}

