/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.dto;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.ParameterResolutionException;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.ast.api.serialization.ExtensionModelResolver;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.builder.adapter.MetadataTypeModelAdapter;
import org.mule.runtime.ast.internal.model.ParameterModelUtils;
import org.mule.runtime.ast.internal.model.RawParameterModel;
import org.mule.runtime.ast.internal.param.ExpressionAwareParameter;
import org.mule.runtime.ast.internal.param.ParamTypeResolvingVisitor;
import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerMetadata;
import org.mule.runtime.ast.internal.serialization.dto.ArtifactAstSerializerMetadataAware;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentGenerationInformationDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentMetadataAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ImportedResourceDTO;
import org.mule.runtime.ast.internal.serialization.dto.ParameterValueContainer;
import org.mule.runtime.ast.internal.serialization.resolver.GenerationInformationResolver;
import org.mule.runtime.ast.internal.serialization.visitor.ArrayMetadataVisitor;
import org.mule.runtime.ast.internal.serialization.visitor.SetComponentAstDTOTypeMetadataTypeVisitor;
import org.mule.runtime.ast.internal.serialization.visitor.UnionTypesVisitor;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentParameterAstDTO
implements ComponentParameterAst,
ExpressionAwareParameter,
ArtifactAstSerializerMetadataAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentParameterAstDTO.class);
    private final String unresolvedValue;
    private final ComponentMetadataAstDTO metadata;
    private final String groupModelName;
    private final String modelName;
    private ParameterValueContainer value;
    private final boolean defaultValue;
    private ComponentGenerationInformationDTO generationInformation;
    private transient String resolvedRawValue;
    private transient ParameterModel model;
    private transient ParameterGroupModel groupModel;
    private transient PropertiesResolver propertiesResolver;
    private transient ArtifactAstSerializerMetadata artifactAstSerializerMetadata;
    private transient ParameterModelUtils parameterModelUtils;

    public ComponentParameterAstDTO(ParameterValueContainer value, String unresolvedValue, boolean defaultValue, ComponentMetadataAstDTO metadata, String groupModelName, String modelName) {
        this.value = value;
        this.unresolvedValue = unresolvedValue;
        this.defaultValue = defaultValue;
        this.metadata = metadata;
        this.groupModelName = groupModelName;
        this.modelName = modelName;
    }

    public ParameterModel getModel() {
        return this.model;
    }

    public ParameterGroupModel getGroupModel() {
        return this.groupModel;
    }

    public <T> Either<String, T> getValue() {
        if (this.value != null && this.value.isFixedValue()) {
            Object containedValue = this.value.getContainedValue();
            if (containedValue instanceof String) {
                this.resolvedRawValue = (String)containedValue;
            }
            return this.rightValue(containedValue);
        }
        if (this.value != null && this.value.isExpression()) {
            return Either.left((Object)this.value.getExpression());
        }
        if (this.unresolvedValue != null) {
            if (this.isAnExpression()) {
                this.resolvedRawValue = this.propertiesResolver != null ? this.propertiesResolver.apply(this.unresolvedValue) : this.unresolvedValue;
                this.value = new ParameterValueContainer(this.extractExpression(this.resolvedRawValue).get(), null);
                return Either.left((Object)this.value.getExpression());
            }
            if (this.propertiesResolver == null) {
                return Either.empty();
            }
            this.resolvedRawValue = this.propertiesResolver.apply(this.unresolvedValue);
            this.value = new ParameterValueContainer(null, ParamTypeResolvingVisitor.resolveParamValue((ExpressionAwareParameter)this, (ComponentMetadataAst)this.metadata, (String)this.resolvedRawValue).getRight());
            return this.rightValue(this.value.getContainedValue());
        }
        if (this.model == null) {
            throw new IllegalStateException("Cannot resolve value for parameter without model");
        }
        Object defaultValue = this.model.getDefaultValue();
        if (defaultValue == null) {
            this.value = null;
            return Either.empty();
        }
        if (defaultValue instanceof String) {
            this.resolvedRawValue = this.propertiesResolver.apply(defaultValue.toString());
            this.value = new ParameterValueContainer(null, this.resolvedRawValue);
            return this.rightValue(this.value.getContainedValue());
        }
        if (this.model.getType().getAnnotation(EnumAnnotation.class).isPresent()) {
            this.resolvedRawValue = ((Enum)defaultValue).name();
            this.value = new ParameterValueContainer(null, this.resolvedRawValue);
            return this.rightValue(this.value.getContainedValue());
        }
        this.value = new ParameterValueContainer(null, defaultValue);
        return this.rightValue(defaultValue);
    }

    public <T> Either<String, Either<ParameterResolutionException, T>> getValueOrResolutionError() {
        try {
            return this.getValue().mapRight(fixedValue -> Either.right((Object)fixedValue));
        }
        catch (ParameterResolutionException e) {
            return Either.right((Object)Either.left((Object)((Object)e)));
        }
    }

    private boolean isAnExpression() {
        return this.model != null && (ExpressionSupport.SUPPORTED.equals((Object)this.model.getExpressionSupport()) || ExpressionSupport.REQUIRED.equals((Object)this.model.getExpressionSupport())) && this.isExpression(this.unresolvedValue);
    }

    public boolean isExpression(Object value) {
        if (value instanceof String) {
            String trim = ((String)value).trim();
            if (trim.startsWith("#[") && trim.endsWith("]")) {
                return true;
            }
            return this.parameterModelUtils.allowsExpressionWithoutMarkers(this.getModel());
        }
        return false;
    }

    private boolean supportsExpressions() {
        return !ExpressionSupport.NOT_SUPPORTED.equals((Object)this.model.getExpressionSupport());
    }

    private boolean serializerUsesOldAllowsExpressionWithoutMarkersModelPropertyClass() {
        return this.artifactAstSerializerMetadata != null && "JSON".equals(this.artifactAstSerializerMetadata.getSerializerId()) && "1.0".equals(this.artifactAstSerializerMetadata.getSerializerVersion());
    }

    private boolean hasBrokenValue(ParameterModelUtils parameterModelUtils) {
        return this.serializerUsesOldAllowsExpressionWithoutMarkersModelPropertyClass() && this.value.isFixedValue() && this.supportsExpressions() && parameterModelUtils.allowsExpressionWithoutMarkers(this.getModel());
    }

    public Optional<String> extractExpression(Object value) {
        String expression;
        Optional<String> result = Optional.empty();
        if (this.isExpression(value) && StringUtils.isNotEmpty((CharSequence)(expression = (String)value))) {
            String trimmedText = expression.trim();
            result = trimmedText.startsWith("#[") && trimmedText.endsWith("]") ? Optional.of(trimmedText.substring("#[".length(), trimmedText.length() - "]".length())) : Optional.of(trimmedText);
        }
        return result;
    }

    private <T> Either<String, T> rightValue(Object value) {
        return Either.right(String.class, (Object)value);
    }

    public String getRawValue() {
        return this.unresolvedValue;
    }

    public String getResolvedRawValue() {
        if (this.resolvedRawValue == null) {
            this.getValue();
        }
        if (this.resolvedRawValue == null) {
            this.resolvedRawValue = this.unresolvedValue;
        }
        return this.resolvedRawValue;
    }

    public Optional<ComponentMetadataAst> getMetadata() {
        return Optional.ofNullable(this.metadata);
    }

    public ComponentGenerationInformation getGenerationInformation() {
        return this.generationInformation;
    }

    public boolean isDefaultValue() {
        return this.defaultValue;
    }

    public void setModel(ParameterModel parameterModel, ParameterGroupModel parameterGroupModel, ParameterModelUtils parameterModelUtils) {
        this.model = parameterModel;
        this.groupModel = parameterGroupModel;
        this.parameterModelUtils = Objects.requireNonNull(parameterModelUtils);
        if (this.value != null && this.hasBrokenValue(parameterModelUtils)) {
            this.value = null;
            this.getValue();
        }
    }

    public void setGenerationInformation(ComponentGenerationInformationDTO generationInformation) {
        this.generationInformation = generationInformation;
    }

    public String getGroupModelName() {
        return this.groupModelName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setPropertiesResolver(PropertiesResolver propertiesResolver) {
        this.propertiesResolver = propertiesResolver;
        if (this.value != null && this.value.isFixedValue() && this.isValueAListOfComponentAstDTOs()) {
            List componentAstDTOS = (List)this.value.getContainedValue();
            componentAstDTOS.forEach(componentAstDTO -> componentAstDTO.setPropertiesResolver(propertiesResolver));
        }
        if (this.value != null && this.value.isFixedValue() && this.isValueAComponentAstDTO()) {
            ComponentAstDTO componentAstDTO2 = (ComponentAstDTO)((Object)this.value.getContainedValue());
            componentAstDTO2.setPropertiesResolver(propertiesResolver);
        }
        propertiesResolver.onMappingFunctionChanged(() -> {
            if (MuleAstUtils.hasPropertyPlaceholder((String)this.unresolvedValue)) {
                this.resolvedRawValue = null;
                this.value = null;
            }
        });
    }

    public PropertiesResolver getPropertiesResolver() {
        return this.propertiesResolver;
    }

    public String toString() {
        return "ComponentParameterAstDTO{groupModelName='" + this.groupModelName + "', modelName='" + this.modelName + "', value='" + this.value + ", unresolvedValue='" + this.unresolvedValue + "'}";
    }

    private void resolveMapEntriesElementsModels(ComponentAstDTO parentComponentAstDTO, ExtensionModelHelper extensionModelHelper, ExtensionModelResolver extensionModelResolver, GenerationInformationResolver generationInformationResolver, ParameterModelUtils parameterModelUtils) {
        List<ComponentAstDTO> componentAstDTOList = this.getValueAsComponentAstDTOList();
        componentAstDTOList.forEach(componentAstDTO -> {
            componentAstDTO.resolveMapEntryComponentModels(parentComponentAstDTO, this, extensionModelHelper, extensionModelResolver, generationInformationResolver, parameterModelUtils);
            componentAstDTO.directChildrenStream().map(childComponentAst -> (ComponentAstDTO)((Object)((Object)childComponentAst))).forEach(childComponentAstDTO -> childComponentAstDTO.resolveModelsRecursively((ComponentAstDTO)((Object)componentAstDTO), extensionModelHelper, extensionModelResolver, generationInformationResolver, parameterModelUtils));
        });
    }

    public void resolveListElementModels(ComponentAstDTO parentComponentAstDTO, ExtensionModelHelper extensionModelHelper, ExtensionModelResolver extensionModelResolver, GenerationInformationResolver generationInformationResolver, ParameterModelUtils parameterModelUtils) {
        this.model.getType().accept((MetadataTypeVisitor)new ArrayMetadataVisitor(this, parentComponentAstDTO, extensionModelHelper, generationInformationResolver, extensionModelResolver, parameterModelUtils));
    }

    public ParameterModel resolveParameterModelFromOwnerMetadataTypeModelAdapter(MetadataTypeModelAdapter metadataTypeModelAdapter) {
        return metadataTypeModelAdapter.getAllParameterModels().stream().filter(parameterModel -> parameterModel.getName().equals(this.getModelName())).findFirst().orElse((ParameterModel)new RawParameterModel(this.modelName));
    }

    void resolveModelParameter(ComponentAstDTO ownerComponentAstDTO, ExtensionModelHelper extensionModelHelper, ExtensionModelResolver extensionModelResolver, GenerationInformationResolver generationInformationResolver, ParameterModelUtils parameterModelUtils) {
        LOGGER.debug("Enrichment: resolveModelParameter({}, {})", (Object)ownerComponentAstDTO, (Object)this);
        this.setModel(ownerComponentAstDTO.resolveParameterModel(this), ownerComponentAstDTO.resolveParameterGroupModel(this), parameterModelUtils);
        LOGGER.debug("Enrichment: resolveModelParameter, resolved groupModel and model: {}, {}", (Object)this.groupModel, (Object)this.model);
        AtomicBoolean paramProcessed = new AtomicBoolean();
        if (this.model.getType() != null) {
            this.model.getType().accept((MetadataTypeVisitor)new UnionTypesVisitor(this, extensionModelHelper, paramProcessed));
        }
        if (ownerComponentAstDTO.isWrapped(this, extensionModelHelper)) {
            LOGGER.debug("Enrichment: resolveModelParameter, isWrapped {}", (Object)ownerComponentAstDTO, (Object)this);
            this.resolveParameterValueModel(ownerComponentAstDTO, extensionModelHelper, extensionModelResolver, generationInformationResolver, parameterModelUtils);
            if (!paramProcessed.get()) {
                this.generationInformation = generationInformationResolver.resolveWrappedComponentParameterAstGenerationInformation(this, ownerComponentAstDTO, extensionModelHelper);
                LOGGER.debug("Enrichment: resolveModelParameter, generationInformation: {}", (Object)this.generationInformation);
            }
        } else {
            if (!paramProcessed.get()) {
                this.generationInformation = generationInformationResolver.resolveRegularComponentParameterAstGenerationInformation(this, ownerComponentAstDTO, extensionModelHelper);
                LOGGER.debug("Enrichment: resolveModelParameter, generationInformation: {}", (Object)this.generationInformation);
            }
            this.resolveParameterValueModel(ownerComponentAstDTO, extensionModelHelper, extensionModelResolver, generationInformationResolver, parameterModelUtils);
        }
    }

    public boolean isValueAComponentAstDTO() {
        Either value = this.getValue();
        return value != null && value.isRight() && value.getRight() instanceof ComponentAstDTO;
    }

    public boolean isValueAListOfComponentAstDTOs() {
        Either value = this.getValue();
        return value != null && value.isRight() && value.getRight() instanceof List && !((List)value.getRight()).isEmpty() && ((List)value.getRight()).get(0) instanceof ComponentAstDTO;
    }

    public boolean isValueAList() {
        Either value = this.getValue();
        return value != null && value.isRight() && value.getRight() instanceof List;
    }

    private void resolveParameterValueModel(ComponentAstDTO parentComponentAstDTO, ExtensionModelHelper extensionModelHelper, ExtensionModelResolver extensionModelResolver, GenerationInformationResolver generationInformationResolver, ParameterModelUtils parameterModelUtils) {
        if (this.isValueAComponentAstDTO()) {
            ComponentAstDTO valueComponentAstDTO = this.getValueAsComponentAstDTO();
            LOGGER.debug("Enrichment: resolveParameterValueModel, value is ComponentAstDTO, parameter {} value {}", (Object)this, (Object)valueComponentAstDTO);
            this.model.getType().accept((MetadataTypeVisitor)new SetComponentAstDTOTypeMetadataTypeVisitor(valueComponentAstDTO));
            valueComponentAstDTO.resolveModelsRecursively(parentComponentAstDTO, extensionModelHelper, extensionModelResolver, generationInformationResolver, parameterModelUtils);
        } else if (this.isValueAList()) {
            if (ExtensionMetadataTypeUtils.isMap((MetadataType)this.model.getType())) {
                LOGGER.debug("Enrichment: resolveParameterValueModel, value is list of Map, parameter {}", (Object)this);
                this.resolveMapEntriesElementsModels(parentComponentAstDTO, extensionModelHelper, extensionModelResolver, generationInformationResolver, parameterModelUtils);
            } else {
                LOGGER.debug("Enrichment: resolveParameterValueModel, value is list, parameter {}", (Object)this);
                this.resolveListElementModels(parentComponentAstDTO, extensionModelHelper, extensionModelResolver, generationInformationResolver, parameterModelUtils);
            }
        }
    }

    public void resolveMapEntryAttribute(ParameterModel ownerParameterModel, ComponentGenerationInformation ownerParameterGenerationInformation, ExtensionModelHelper extensionModelHelper, ExtensionModelResolver extensionModelResolver, GenerationInformationResolver generationInformationResolver, ComponentAstDTO componentAstDTO, ParameterModelUtils parameterModelUtils) {
        switch (this.modelName) {
            case "key": {
                this.setModel(ComponentParameterAstDTO.createParameterModelForMapEntry(this.modelName, extensionModelHelper.findMetadataType(String.class).orElse(null)), componentAstDTO.resolveParameterGroupModel(this), parameterModelUtils);
                this.generationInformation = generationInformationResolver.resolveGenerationInformationThroughParent(this.modelName, componentAstDTO, ownerParameterModel, ownerParameterGenerationInformation);
                break;
            }
            case "value": {
                this.setModel(ComponentParameterAstDTO.createParameterModelForMapEntry(this.modelName, this.resolveMapEntryValueType(ownerParameterModel)), componentAstDTO.resolveParameterGroupModel(this), parameterModelUtils);
                this.generationInformation = generationInformationResolver.resolveGenerationInformationThroughParent(this.modelName, componentAstDTO, ownerParameterModel, ownerParameterGenerationInformation);
                this.resolveParameterValueModel(componentAstDTO, extensionModelHelper, extensionModelResolver, generationInformationResolver, parameterModelUtils);
                break;
            }
            case "name": {
                this.setModel((ParameterModel)new RawParameterModel(this.getModelName()), componentAstDTO.resolveParameterGroupModel(this), parameterModelUtils);
                this.generationInformation = generationInformationResolver.resolveComponentParameterAstGenerationInformation(this, componentAstDTO, extensionModelHelper);
            }
        }
    }

    private static ParameterModel createParameterModelForMapEntry(String name, MetadataType metadataType) {
        return new ImmutableParameterModel(name, "", metadataType, false, true, false, false, ExpressionSupport.SUPPORTED, null, ParameterRole.BEHAVIOUR, null, null, null, null, Collections.emptyList(), Collections.emptySet());
    }

    private MetadataType resolveMapEntryValueType(ParameterModel ownerParameterModel) {
        if (ownerParameterModel.getType() instanceof ObjectType && ((ObjectType)ownerParameterModel.getType()).getOpenRestriction().isPresent()) {
            return (MetadataType)((ObjectType)ownerParameterModel.getType()).getOpenRestriction().get();
        }
        return ownerParameterModel.getType();
    }

    private ComponentAstDTO getValueAsComponentAstDTO() {
        return (ComponentAstDTO)((Object)this.getValue().getRight());
    }

    private List<ComponentAstDTO> getValueAsComponentAstDTOList() {
        return (List)this.getValue().getRight();
    }

    void resolveInfrastructureParameter(ComponentAstDTO ownerComponentAstDTO, ExtensionModelHelper extensionModelHelper, GenerationInformationResolver generationInformationResolver) {
        LOGGER.debug("Enrichment: resolveInfrastructureParameter: {} - {}", (Object)ownerComponentAstDTO, (Object)this);
        ParameterizedModel parameterizedModel = ownerComponentAstDTO.getModel(ParameterizedModel.class).get();
        this.model = this.resolveParameterModelFromOwnerMetadataTypeModelAdapter((MetadataTypeModelAdapter)parameterizedModel);
        this.groupModel = parameterizedModel.getParameterGroupModels().stream().filter(parameterModel -> parameterModel.getName().equals(this.getGroupModelName())).findFirst().orElse(null);
        AtomicBoolean paramProcessed = new AtomicBoolean();
        this.model.getType().accept((MetadataTypeVisitor)new UnionTypesVisitor(this, extensionModelHelper, paramProcessed));
        if (!paramProcessed.get()) {
            this.generationInformation = generationInformationResolver.crateComponentGenerationInformationFromParent(ownerComponentAstDTO, this);
        }
    }

    void enrichWithImportedResources(Map<String, ImportedResourceDTO> importResourcesByRawLocation) {
        LOGGER.debug("Enrichment: enrichWithImportedResources: {}", (Object)this);
        if (this.metadata != null) {
            this.metadata.enrich(importResourcesByRawLocation);
        }
        if (this.isValueAComponentAstDTO()) {
            this.getValueAsComponentAstDTO().enrichWithImportedResources(importResourcesByRawLocation);
            return;
        }
        if (this.isValueAListOfComponentAstDTOs()) {
            this.getValueAsComponentAstDTOList().forEach(componentAstDTO -> componentAstDTO.enrichWithImportedResources(importResourcesByRawLocation));
            return;
        }
    }

    void resolveSimpleTypeComponentParameter(ComponentAstDTO ownerComponentAstDTO, SimpleType simpleType, ExtensionModelHelper extensionModelHelper, GenerationInformationResolver generationInformationResolver, ParameterModelUtils parameterModelUtils) {
        MetadataTypeModelAdapter simpleWrapperTypeModelAdapter = MetadataTypeModelAdapter.createSimpleWrapperTypeModelAdapter((SimpleType)simpleType, (ExtensionModelHelper)extensionModelHelper);
        this.setModel(this.resolveParameterModelFromOwnerMetadataTypeModelAdapter(simpleWrapperTypeModelAdapter), ownerComponentAstDTO.resolveParameterGroupModel(this), parameterModelUtils);
        this.generationInformation = generationInformationResolver.resolveComponentParameterAstGenerationInformation(this, ownerComponentAstDTO, extensionModelHelper);
    }

    @Override
    public void setArtifactAstSerializerMetadata(ArtifactAstSerializerMetadata artifactAstSerializerMetadata) {
        this.artifactAstSerializerMetadata = artifactAstSerializerMetadata;
    }
}

