/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.mediatype;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.mule.runtime.api.streaming.HasSize;
import org.mule.runtime.core.internal.util.mediatype.MediaTypeDecoratedResultList;
import org.mule.sdk.api.runtime.operation.Result;

public class MediaTypeDecoratedResultListIterator
implements ListIterator<Result>,
HasSize {
    private final MediaTypeDecoratedResultList delegate;
    private final int size;
    private int index;
    private int lastIndex = 0;

    public MediaTypeDecoratedResultListIterator(MediaTypeDecoratedResultList delegate) {
        this(delegate, 0);
    }

    public MediaTypeDecoratedResultListIterator(MediaTypeDecoratedResultList delegate, int startIndex) {
        this.delegate = delegate;
        this.index = startIndex;
        this.size = delegate.size();
    }

    @Override
    public boolean hasNext() {
        return this.index < this.size;
    }

    @Override
    public Result next() {
        this.lastIndex = this.index++;
        return this.delegate.get(this.lastIndex);
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public Result previous() {
        if (this.index == 0) {
            throw new NoSuchElementException();
        }
        this.lastIndex = this.index - 1;
        return this.delegate.get(this.lastIndex);
    }

    @Override
    public int nextIndex() {
        return this.index < this.size ? this.index : this.size;
    }

    @Override
    public int previousIndex() {
        return this.index > 0 ? this.index - 1 : -1;
    }

    public int getSize() {
        return this.delegate instanceof HasSize ? ((HasSize)this.delegate).getSize() : -1;
    }

    @Override
    public void remove() {
        this.delegate.remove(this.lastIndex);
    }

    @Override
    public void set(Result result) {
        this.delegate.set(this.lastIndex, result);
    }

    @Override
    public void add(Result result) {
        this.delegate.add(this.index, result);
    }
}

