/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.internal.streaming.bytes.AbstractCursorStream;
import org.mule.runtime.core.internal.streaming.bytes.ByteStreamingConstants;
import org.mule.runtime.core.internal.streaming.bytes.InputStreamBuffer;

public final class BufferedCursorStream
extends AbstractCursorStream {
    private static final int LOCAL_BUFFER_SIZE = ByteStreamingConstants.DEFAULT_BUFFER_BUCKET_SIZE;
    private static final ByteBuffer NULL_BUFFER = ByteBuffer.allocate(0);
    private final InputStreamBuffer streamBuffer;
    private ByteBuffer localBuffer = NULL_BUFFER;
    private long rangeStart = 0L;
    private long rangeEnd = -1L;

    public BufferedCursorStream(InputStreamBuffer streamBuffer, CursorStreamProvider provider) {
        super(provider);
        this.streamBuffer = streamBuffer;
    }

    @Override
    public void seek(long position) throws IOException {
        super.seek(position);
        boolean reset = false;
        if (position < this.rangeStart || position >= this.rangeEnd) {
            reset = true;
        } else {
            int bufferPosition = Math.toIntExact(position - this.rangeStart);
            if (bufferPosition >= this.localBuffer.limit()) {
                reset = true;
            } else {
                this.localBuffer.position(bufferPosition);
            }
        }
        if (reset) {
            this.localBuffer.clear();
            this.localBuffer.flip();
            this.rangeStart = position;
            this.rangeEnd = -1L;
        }
    }

    @Override
    protected int doRead() throws IOException {
        if (this.assureDataInLocalBuffer(1) == -1) {
            return -1;
        }
        int read = this.unsigned(this.localBuffer.get());
        ++this.position;
        return read;
    }

    @Override
    protected int doRead(byte[] b, int off, int len) throws IOException {
        int read = 0;
        int remaining;
        while ((remaining = this.assureDataInLocalBuffer(len)) != -1) {
            if (len <= remaining) {
                this.localBuffer.get(b, off, len);
                this.position += (long)len;
                return read + len;
            }
            this.localBuffer.get(b, off, remaining);
            this.position += (long)remaining;
            read += remaining;
            off += remaining;
            len -= remaining;
        }
        return read == 0 ? -1 : read;
    }

    private int assureDataInLocalBuffer(int len) {
        if (len <= this.localBuffer.remaining()) {
            return Math.toIntExact(len);
        }
        this.localBuffer.clear();
        ByteBuffer read = this.streamBuffer.get(this.position, LOCAL_BUFFER_SIZE);
        if (read != null) {
            this.localBuffer = read;
            this.rangeStart = this.position;
            this.rangeEnd = this.rangeStart + (long)read.remaining();
            return read.remaining();
        }
        this.localBuffer.limit(0);
        return -1;
    }
}

