/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.streaming.bytes;

import java.io.InputStream;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.core.api.streaming.bytes.AbstractCursorStreamProvider;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamConfig;
import org.mule.runtime.core.internal.streaming.bytes.BufferedCursorStream;
import org.mule.runtime.core.internal.streaming.bytes.InMemoryStreamBuffer;

public final class InMemoryCursorStreamProvider
extends AbstractCursorStreamProvider {
    private final InMemoryStreamBuffer buffer;

    public InMemoryCursorStreamProvider(InputStream wrappedStream, InMemoryCursorStreamConfig config, ByteBufferManager bufferManager, ComponentLocation originatingLocation, boolean trackCursorProviderClose) {
        super(wrappedStream, originatingLocation, trackCursorProviderClose);
        this.buffer = new InMemoryStreamBuffer(wrappedStream, config, bufferManager);
    }

    @Deprecated
    public InMemoryCursorStreamProvider(InputStream wrappedStream, InMemoryCursorStreamConfig config, ByteBufferManager bufferManager) {
        this(wrappedStream, config, bufferManager, null, false);
    }

    @Override
    protected CursorStream doOpenCursor() {
        return new BufferedCursorStream(this.buffer, this);
    }

    public void releaseResources() {
        if (this.buffer != null) {
            this.buffer.close();
        }
    }
}

