/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.concurrent.Executor;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventLifeCycleListener;
import org.glassfish.grizzly.strategies.AbstractIOStrategy;
import org.mule.runtime.api.scheduler.SchedulerBusyException;
import org.mule.service.http.impl.service.server.DefaultServerAddress;
import org.mule.service.http.impl.service.server.grizzly.ExecutorProvider;
import org.slf4j.Logger;

public class ExecutorPerServerAddressIOStrategy
extends AbstractIOStrategy {
    private static final EnumSet<IOEvent> WORKER_THREAD_EVENT_SET = EnumSet.of(IOEvent.WRITE);
    public static final String DELEGATE_WRITES_IN_CONFIGURED_EXECUTOR = "__WRITES_TO_IO__";
    private static final Logger logger = Grizzly.logger(ExecutorPerServerAddressIOStrategy.class);
    private final ExecutorProvider executorProvider;

    public ExecutorPerServerAddressIOStrategy(ExecutorProvider executorProvider) {
        this.executorProvider = executorProvider;
    }

    public boolean executeIoEvent(Connection connection, IOEvent ioEvent, boolean isIoEventEnabled) throws IOException {
        IOEventLifeCycleListener listener;
        boolean isReadOrWriteEvent = ExecutorPerServerAddressIOStrategy.isReadWrite((IOEvent)ioEvent);
        if (isReadOrWriteEvent) {
            if (isIoEventEnabled) {
                connection.disableIOEvent(ioEvent);
            }
            listener = ENABLE_INTEREST_LIFECYCLE_LISTENER;
        } else {
            listener = null;
        }
        Executor threadPool = this.getThreadPoolFor(connection, ioEvent);
        if (threadPool != null) {
            try {
                threadPool.execute(new WorkerThreadRunnable(connection, ioEvent, listener));
            }
            catch (SchedulerBusyException ex) {
                ExecutorPerServerAddressIOStrategy.run0(connection, ioEvent, listener);
            }
        } else {
            ExecutorPerServerAddressIOStrategy.run0(connection, ioEvent, listener);
        }
        return true;
    }

    public Executor getThreadPoolFor(Connection connection, IOEvent ioEvent) {
        if (this.mustSwitchThread(connection, ioEvent)) {
            InetSocketAddress socketAddress = (InetSocketAddress)connection.getLocalAddress();
            InetAddress address = socketAddress.getAddress();
            int port = socketAddress.getPort();
            return this.executorProvider.getExecutor(new DefaultServerAddress(address, port));
        }
        return null;
    }

    private boolean mustSwitchThread(Connection connection, IOEvent ioEvent) {
        Object delegateToConfigured = connection.getAttributes().getAttribute(DELEGATE_WRITES_IN_CONFIGURED_EXECUTOR);
        return delegateToConfigured instanceof Boolean && (Boolean)delegateToConfigured != false && WORKER_THREAD_EVENT_SET.contains(ioEvent);
    }

    private static void run0(Connection connection, IOEvent ioEvent, IOEventLifeCycleListener lifeCycleListener) {
        ExecutorPerServerAddressIOStrategy.fireIOEvent((Connection)connection, (IOEvent)ioEvent, (IOEventLifeCycleListener)lifeCycleListener, (Logger)logger);
    }

    private static final class WorkerThreadRunnable
    implements Runnable {
        final Connection connection;
        final IOEvent ioEvent;
        final IOEventLifeCycleListener lifeCycleListener;
        final ClassLoader classLoader;

        private WorkerThreadRunnable(Connection connection, IOEvent ioEvent, IOEventLifeCycleListener lifeCycleListener) {
            this.connection = connection;
            this.ioEvent = ioEvent;
            this.lifeCycleListener = lifeCycleListener;
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }

        @Override
        public void run() {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                ExecutorPerServerAddressIOStrategy.run0(this.connection, this.ioEvent, this.lifeCycleListener);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }
}

