/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client;

import com.ning.http.client.RequestBuilder;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.cookie.CookieDecoder;
import java.util.Collection;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.server.HttpServerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHeaderPopulator {
    private static final String DISABLE_COOKIE_SPECIAL_HANDLING_PROPERTY = "mule.http.cookie.special.handling.disable";
    private static final boolean DISABLE_COOKIE_SPECIAL_HANDLING = Boolean.getBoolean("mule.http.cookie.special.handling.disable");
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestHeaderPopulator.class);
    private static final String HEADER_CONNECTION = "Connection".toLowerCase();
    private static final String HEADER_CONTENT_LENGTH = "Content-Length".toLowerCase();
    private static final String HEADER_TRANSFER_ENCODING = "Transfer-Encoding".toLowerCase();
    private static final String HEADER_COOKIE = "Cookie".toLowerCase();
    private static final String COOKIE_SEPARATOR = ";";
    private final boolean usePersistentConnections;

    public RequestHeaderPopulator(boolean usePersistentConnections) {
        this.usePersistentConnections = usePersistentConnections;
    }

    public void populateHeaders(HttpRequest request, RequestBuilder builder) {
        boolean hasTransferEncoding = false;
        boolean hasContentLength = false;
        boolean hasConnection = false;
        for (String headerName : request.getHeaderNames()) {
            boolean specialHeader = false;
            if (!hasTransferEncoding && headerName.equalsIgnoreCase(HEADER_TRANSFER_ENCODING)) {
                hasTransferEncoding = true;
                specialHeader = true;
                builder.addHeader(HttpServerProperties.PRESERVE_HEADER_CASE ? "Transfer-Encoding" : HEADER_TRANSFER_ENCODING, request.getHeaderValue(headerName));
            }
            if (!hasContentLength && headerName.equalsIgnoreCase(HEADER_CONTENT_LENGTH)) {
                hasContentLength = true;
                specialHeader = true;
                builder.addHeader(HttpServerProperties.PRESERVE_HEADER_CASE ? "Content-Length" : HEADER_CONTENT_LENGTH, request.getHeaderValue(headerName));
            }
            if (!hasContentLength && headerName.equalsIgnoreCase(HEADER_CONNECTION)) {
                hasConnection = true;
                specialHeader = true;
                builder.addHeader(HttpServerProperties.PRESERVE_HEADER_CASE ? "Connection" : HEADER_CONNECTION, request.getHeaderValue(headerName));
            }
            if (this.mustTreatCookieAsASpecialHeader() && headerName.equalsIgnoreCase(HEADER_COOKIE)) {
                specialHeader = true;
                this.parseCookieHeaderAndAddCookies(builder, request.getHeaderValues(headerName));
            }
            if (specialHeader) continue;
            for (String headerValue : request.getHeaderValues(headerName)) {
                builder.addHeader(headerName, headerValue);
            }
        }
        if (!hasTransferEncoding && !hasContentLength && request.getEntity().getBytesLength().isPresent()) {
            builder.addHeader(HttpServerProperties.PRESERVE_HEADER_CASE ? "Content-Length" : HEADER_CONTENT_LENGTH, String.valueOf(request.getEntity().getBytesLength().getAsLong()));
        }
        if (!this.usePersistentConnections) {
            if (hasConnection && LOGGER.isDebugEnabled() && !"close".equals(request.getHeaderValue(HEADER_CONNECTION))) {
                LOGGER.debug("Persistent connections are disabled in the HTTP requester configuration, but the request already contains a Connection header with value {}. This header will be ignored, and a Connection: close header will be sent instead.", (Object)request.getHeaderValue(HEADER_CONNECTION));
            }
            builder.setHeader(HttpServerProperties.PRESERVE_HEADER_CASE ? "Connection" : HEADER_CONNECTION, "close");
        }
    }

    private boolean mustTreatCookieAsASpecialHeader() {
        return !DISABLE_COOKIE_SPECIAL_HANDLING;
    }

    private void parseCookieHeaderAndAddCookies(RequestBuilder builder, Collection<String> headerValues) {
        try {
            if (headerValues == null) {
                LOGGER.warn("A null value was retrieved as the collection of cookie headers");
                return;
            }
            for (String cookieHeader : headerValues) {
                if (cookieHeader == null) {
                    LOGGER.warn("Detected a cookie header with a null value");
                    continue;
                }
                for (String eachCookie : cookieHeader.split(COOKIE_SEPARATOR)) {
                    Cookie decodedCookiePair = CookieDecoder.decode((String)(eachCookie = eachCookie.trim()).trim());
                    if (decodedCookiePair == null) {
                        LOGGER.warn("Couldn't decode '{}' as a cookie-pair. See RFC-6265, section 4.2.1 (Cookie header syntax)", (Object)eachCookie);
                        continue;
                    }
                    builder.addOrReplaceCookie(decodedCookiePair);
                }
            }
        }
        catch (NullPointerException npe) {
            LOGGER.error("This should never happen, but it was added because of repeated problems with NPEs in this code", (Throwable)npe);
        }
    }
}

