/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.params;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AdditionalJvmParameters {
    protected static String jpdaOpts = "";
    protected static int paramIndex = -1;
    protected static int classpathIndex = 0;
    static final String wrapperPrefix = "wrapper.java.additional.";
    static final String classpathPrefix = "wrapper.java.classpath.";
    static final int DEFAULT_NUMBER_OF_ADDITIONAL_JAVA_ARGUMENTS = 0;

    public static void main(String[] args) throws IOException {
        File wrapperConfigFile = new File(args[0]);
        jpdaOpts = args[1];
        String wrapperConfDir = AdditionalJvmParameters.extractWrapperConfDir(wrapperConfigFile);
        File wrapperAdditionalConfFile = new File(wrapperConfDir + "wrapper-additional.conf");
        FileWriter writer = new FileWriter(wrapperAdditionalConfFile);
        AdditionalJvmParameters.writeHeader(writer);
        List<String> arguments = Arrays.asList(args);
        boolean debugEnabled = AdditionalJvmParameters.isDebugEnabled(arguments);
        boolean adHocOptionsAvailable = AdditionalJvmParameters.isOptionAvailable(arguments, "-M");
        boolean wrapperOptionsAvailable = AdditionalJvmParameters.isOptionAvailable(arguments, "-W");
        BufferedReader reader = new BufferedReader(new FileReader(wrapperConfigFile));
        String line = reader.readLine();
        while (line != null) {
            paramIndex = AdditionalJvmParameters.findWrapperAdditionalProperties(line);
            classpathIndex = AdditionalJvmParameters.findWrapperClassPathEntries(line);
            line = reader.readLine();
        }
        reader.close();
        if (debugEnabled || adHocOptionsAvailable) {
            paramIndex += AdditionalJvmParameters.getNumberOfAdditionalJavaProperties(args);
            if (debugEnabled) {
                AdditionalJvmParameters.writeJpdaOpts(writer);
            }
            if (adHocOptionsAvailable) {
                AdditionalJvmParameters.writeAdHocProps(args, writer);
            }
            if (wrapperOptionsAvailable) {
                AdditionalJvmParameters.writeWrapperProps(args, writer);
            }
        }
        Properties bootstrapProps = new Properties();
        bootstrapProps.load(new FileInputStream(new File(wrapperConfDir + "java11-plus/wrapper.jvmDependant.conf")));
        AdditionalJvmParameters.processBootstrapProperties(bootstrapProps, writer);
        File wrapperLicenseConfFile = new File(wrapperConfDir + "java11-plus/wrapper-license.conf");
        if (wrapperLicenseConfFile.exists()) {
            Files.copy(wrapperLicenseConfFile.toPath(), new File(wrapperConfDir + "wrapper-license.conf").toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        writer.close();
    }

    protected static String extractWrapperConfDir(File wrapperConfigFile) {
        Pattern pattern = Pattern.compile("^.*[\\\\/]");
        String path = wrapperConfigFile.getPath();
        Matcher matcher = pattern.matcher(path);
        matcher.find();
        return matcher.group(0);
    }

    protected static void writeHeader(FileWriter writer) throws IOException {
        writer.write("#encoding=UTF-8\n");
        writer.write("# Do not edit this file!\n");
        writer.write("# This is a generated file to add additional parameters to JVM and Wrapper\n");
        writer.flush();
    }

    protected static boolean isDebugEnabled(List<String> arguments) {
        return arguments.stream().anyMatch("-debug"::equalsIgnoreCase);
    }

    protected static boolean isOptionAvailable(List<String> arguments, String s) {
        return arguments.stream().anyMatch(arg -> arg.startsWith(s));
    }

    protected static int findWrapperAdditionalProperties(String line) {
        Pattern prefixPattern = Pattern.compile("^\\s*wrapper\\.java\\.additional\\..+");
        Matcher prefixMatcher = prefixPattern.matcher(line);
        if (prefixMatcher.find()) {
            Pattern prefixWithNumPattern = Pattern.compile("^\\s*wrapper\\.java\\.additional\\.(\\d+).+");
            Matcher prefixWithNumMatcher = prefixWithNumPattern.matcher(line);
            prefixWithNumMatcher.find();
            return Math.max(Integer.parseInt(prefixWithNumMatcher.group(1)), paramIndex);
        }
        return paramIndex;
    }

    protected static int findWrapperClassPathEntries(String line) {
        Pattern prefixPattern = Pattern.compile("^\\s*wrapper\\.java\\.classpath\\..+");
        Matcher prefixMatcher = prefixPattern.matcher(line);
        if (prefixMatcher.find()) {
            Pattern prefixWithNumPattern = Pattern.compile("^\\s*wrapper\\.java\\.classpath\\.(\\d+).+");
            Matcher prefixWithNumMatcher = prefixWithNumPattern.matcher(line);
            prefixWithNumMatcher.find();
            return Math.max(Integer.parseInt(prefixWithNumMatcher.group(1)), classpathIndex);
        }
        return classpathIndex;
    }

    protected static int getNumberOfAdditionalJavaProperties(String[] args) {
        boolean propertyExists = false;
        String propertyPrefix = "-additionalJavaProperties=(\\d+)+";
        String additionalJavaArgument = "";
        for (String arg : args) {
            if (!arg.matches(propertyPrefix)) continue;
            propertyExists = true;
            additionalJavaArgument = arg;
        }
        if (propertyExists) {
            Pattern argPattern = Pattern.compile(propertyPrefix);
            Matcher additionalJavaArgMatcher = argPattern.matcher(additionalJavaArgument);
            additionalJavaArgMatcher.find();
            return Integer.parseInt(additionalJavaArgMatcher.group(1));
        }
        return 0;
    }

    protected static void writeJpdaOpts(FileWriter writer) throws IOException {
        List<String> jvmArgs = Arrays.asList(jpdaOpts.split("\\s-"));
        for (String arg : jvmArgs) {
            writer.write(wrapperPrefix + ++paramIndex + "=-" + arg.replaceFirst("^-", "") + "\n");
            writer.flush();
        }
    }

    protected static void writeAdHocProps(String[] args, FileWriter writer) throws IOException {
        List adHocArgs = Arrays.stream(args).filter(arg -> arg.startsWith("-M")).collect(Collectors.toList());
        for (String arg2 : adHocArgs) {
            writer.write(wrapperPrefix + ++paramIndex + "=\"" + arg2.replaceFirst("^-M", "") + "\"\n");
            writer.write(wrapperPrefix + paramIndex + ".stripquotes=TRUE\n");
            writer.flush();
        }
    }

    protected static void writeWrapperProps(String[] args, FileWriter writer) throws IOException {
        List wrapperArgs = Arrays.stream(args).filter(arg -> arg.startsWith("-W")).collect(Collectors.toList());
        for (String arg2 : wrapperArgs) {
            writer.write(arg2.replaceFirst("^-W", "") + "\n");
            writer.flush();
        }
    }

    protected static void processBootstrapProperties(Properties bootstrapProperties, Writer writer) throws IOException {
        Pattern additionalPattern = Pattern.compile("wrapper\\.java\\.additional\\.(<n\\d+>)(\\.\\w+)?");
        HashMap<String, Integer> nComponentIndexMap = new HashMap<String, Integer>();
        for (Map.Entry<Object, Object> entry : bootstrapProperties.entrySet()) {
            Matcher additionalMatcher = additionalPattern.matcher(entry.getKey().toString());
            if (additionalMatcher.matches()) {
                String wrapperSuffix = additionalMatcher.group(2) != null ? additionalMatcher.group(2) : "";
                int index = nComponentIndexMap.computeIfAbsent(additionalMatcher.group(1), k -> ++paramIndex);
                writer.write(wrapperPrefix + index + wrapperSuffix + "=" + entry.getValue().toString() + "\n");
                continue;
            }
            if (entry.getKey().toString().matches("wrapper\\.java\\.classpath\\.<n\\d+>")) {
                writer.write(classpathPrefix + ++classpathIndex + "=" + entry.getValue().toString() + "\n");
                continue;
            }
            writer.write(entry.getKey() + "=" + entry.getValue().toString() + "\n");
        }
        writer.flush();
    }
}

