/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast.visitors;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.tregex.automaton.StateSet;
import com.oracle.truffle.regex.tregex.buffer.LongArrayBuffer;
import com.oracle.truffle.regex.tregex.nfa.ASTStepVisitor;
import com.oracle.truffle.regex.tregex.nfa.TransitionGuard;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.GroupBoundaries;
import com.oracle.truffle.regex.tregex.parser.ast.GroupsWithGuardsIndex;
import com.oracle.truffle.regex.tregex.parser.ast.LookAheadAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookAroundAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.Term;
import com.oracle.truffle.regex.util.TBitSet;
import java.util.Arrays;
import java.util.PrimitiveIterator;
import java.util.Set;
import org.graalvm.collections.EconomicSet;

public abstract class NFATraversalRegexASTVisitor {
    protected final RegexAST ast;
    private Term root;
    private final LongArrayBuffer curPath = new LongArrayBuffer(8);
    private final StateSet<GroupsWithGuardsIndex, Group> insideLoops;
    private final TBitSet insideEmptyGuardGroup;
    private RegexASTNode cur;
    private Set<LookBehindAssertion> traversableLookBehindAssertions;
    private boolean canTraverseCaret = false;
    private TBitSet matchedConditionGroups;
    private boolean forward = true;
    private boolean done = false;
    private boolean shouldRetreat = false;
    private boolean recalcTransitionGuards = false;
    private final EconomicSet<DeduplicationKey> pathDeduplicationSet = EconomicSet.create();
    private final LongArrayBuffer dedupKey = new LongArrayBuffer(8);
    private final TBitSet lookAroundsOnPath;
    private int dollarsOnPath = 0;
    private int caretsOnPath = 0;
    private final int[] lookAroundVisitiedCount;
    private final TBitSet captureGroupUpdates;
    private final TBitSet captureGroupClears;
    private final TBitSet referencedGroupBoundaries;
    private int lastGroup = -1;
    private final TBitSet boundedQuantifiersLoop;
    private final TBitSet boundedQuantifiersExited;
    private final LongArrayBuffer transitionGuards = new LongArrayBuffer(8);
    private long[] transitionGuardsResult = null;
    private static final int PATH_GROUP_ALT_INDEX_OFFSET = 0;
    private static final int PATH_NODE_OFFSET = 16;
    private static final int PATH_GROUP_ACTION_OFFSET = 48;
    private static final long PATH_GROUP_ACTION_ENTER = 0x1000000000000L;
    private static final long PATH_GROUP_ACTION_EXIT = 0x2000000000000L;
    private static final long PATH_GROUP_ACTION_PASS_THROUGH = 0x4000000000000L;
    private static final long PATH_GROUP_ACTION_ESCAPE = 0x8000000000000L;
    private static final long PATH_GROUP_ACTION_ANY = 0xF000000000000L;

    protected NFATraversalRegexASTVisitor(RegexAST ast) {
        this.ast = ast;
        this.insideLoops = StateSet.create(ast.getGroupsWithGuards());
        this.insideEmptyGuardGroup = new TBitSet(ast.getGroupsWithGuards().size());
        this.lookAroundsOnPath = new TBitSet(ast.getSubtrees().size());
        this.lookAroundVisitiedCount = new int[ast.getSubtrees().size()];
        this.captureGroupUpdates = new TBitSet(ast.getNumberOfCaptureGroups() * 2);
        this.captureGroupClears = new TBitSet(ast.getNumberOfCaptureGroups() * 2);
        this.referencedGroupBoundaries = new TBitSet(ast.getNumberOfCaptureGroups() * 2);
        this.boundedQuantifiersLoop = new TBitSet(ast.getQuantifierCount());
        this.boundedQuantifiersExited = new TBitSet(ast.getQuantifierCount());
        PrimitiveIterator.OfInt ofInt = ast.getReferencedGroups().iterator();
        while (ofInt.hasNext()) {
            int i = (Integer)ofInt.next();
            this.referencedGroupBoundaries.set(Group.groupNumberToBoundaryIndexStart(i));
            this.referencedGroupBoundaries.set(Group.groupNumberToBoundaryIndexEnd(i));
        }
    }

    public Set<LookBehindAssertion> getTraversableLookBehindAssertions() {
        return this.traversableLookBehindAssertions;
    }

    public void setTraversableLookBehindAssertions(Set<LookBehindAssertion> traversableLookBehindAssertions) {
        this.traversableLookBehindAssertions = traversableLookBehindAssertions;
    }

    public boolean canTraverseCaret() {
        return this.canTraverseCaret;
    }

    public void setCanTraverseCaret(boolean canTraverseCaret) {
        this.canTraverseCaret = canTraverseCaret;
    }

    public void setMatchedConditionGroups(TBitSet matchedConditionGroups) {
        this.matchedConditionGroups = matchedConditionGroups;
    }

    public TBitSet getMatchedConditionGroups() {
        assert (this.isBuildingDFA());
        return this.matchedConditionGroups;
    }

    protected TBitSet getCurrentMatchedConditionGroups() {
        assert (this.isBuildingDFA());
        if (!this.ast.getProperties().hasConditionalBackReferences()) {
            return this.matchedConditionGroups;
        }
        TBitSet currentMatchedConditionGroups = this.matchedConditionGroups.copy();
        PrimitiveIterator.OfInt ofInt = this.ast.getConditionGroups().iterator();
        while (ofInt.hasNext()) {
            int conditionGroup = (Integer)ofInt.next();
            if (this.getCaptureGroupClears().get(Group.groupNumberToBoundaryIndexEnd(conditionGroup))) {
                currentMatchedConditionGroups.clear(conditionGroup);
            }
            if (!this.getCaptureGroupUpdates().get(Group.groupNumberToBoundaryIndexEnd(conditionGroup))) continue;
            currentMatchedConditionGroups.set(conditionGroup);
        }
        return currentMatchedConditionGroups;
    }

    protected boolean isReverse() {
        return !this.forward;
    }

    public void setReverse(boolean reverse) {
        this.forward = !reverse;
    }

    protected abstract boolean isBuildingDFA();

    protected abstract boolean canPruneAfterUnconditionalFinalState();

    private boolean canTraverseLookArounds() {
        return this.isBuildingDFA();
    }

    protected void run(Term runRoot) {
        this.clearCaptureGroupData();
        this.recalcTransitionGuards = false;
        assert (this.insideLoops.isEmpty());
        assert (this.insideEmptyGuardGroup.isEmpty());
        assert (this.curPath.isEmpty());
        assert (this.dollarsOnPath == 0);
        assert (this.caretsOnPath == 0);
        assert (this.lookAroundsOnPath.isEmpty());
        assert (this.nodeVisitsEmpty()) : Arrays.toString(this.lookAroundVisitiedCount);
        assert (!this.shouldRetreat);
        assert (this.transitionGuards.isEmpty());
        assert (this.captureGroupUpdates.isEmpty());
        assert (this.captureGroupClears.isEmpty());
        assert (this.lastGroup == -1);
        this.root = runRoot;
        this.pathDeduplicationSet.clear();
        if (runRoot.isGroup() && runRoot.getParent().isSubtreeRoot()) {
            this.cur = runRoot;
        } else {
            if (runRoot.isGroup()) {
                this.pushGroupExit(runRoot.asGroup());
            }
            this.advanceTerm(runRoot);
        }
        boolean foundNextTarget = false;
        while (!this.done) {
            while (!this.done && !foundNextTarget) {
                foundNextTarget = this.doAdvance();
                if (!foundNextTarget) continue;
                foundNextTarget = this.deduplicatePath(false);
            }
            if (this.done) break;
            RegexASTNode target = this.pathGetNode(this.curPath.peek());
            this.visit(target);
            if (this.canPruneAfterUnconditionalFinalState() && target.isMatchFound() && !this.dollarsOnPath() && !this.caretsOnPath() && this.lookAroundsOnPath.isEmpty() && !this.hasTransitionGuards()) {
                this.insideLoops.clear();
                this.insideEmptyGuardGroup.clear();
                this.curPath.clear();
                this.clearCaptureGroupData();
                this.clearTransitionGuards();
                this.transitionGuardsResult = null;
                break;
            }
            this.transitionGuardsResult = null;
            this.retreat();
            foundNextTarget = false;
            if (!this.cur.isGroup() || !this.cur.hasEmptyGuard()) continue;
            foundNextTarget = this.advanceTerm(this.cur.asGroup());
        }
        if (this.useTransitionGuards()) {
            this.clearTransitionGuards();
        }
        this.done = false;
    }

    protected abstract void visit(RegexASTNode var1);

    protected abstract void enterLookAhead(LookAheadAssertion var1);

    protected abstract void leaveLookAhead(LookAheadAssertion var1);

    protected boolean caretsOnPath() {
        return this.caretsOnPath > 0;
    }

    protected boolean dollarsOnPath() {
        return this.dollarsOnPath > 0;
    }

    protected boolean hasTransitionGuards() {
        this.calcTransitionGuardsResult();
        return this.transitionGuardsResult.length > 0;
    }

    protected long[] getTransitionGuardsOnPath() {
        this.calcTransitionGuardsResult();
        return this.transitionGuardsResult;
    }

    protected void calcTransitionGuardsResult() {
        if (this.transitionGuardsResult == null) {
            assert (this.useTransitionGuards() || this.getTransitionGuards().isEmpty());
            this.transitionGuardsResult = this.getTransitionGuards().isEmpty() ? TransitionGuard.NO_GUARDS : this.getTransitionGuards().toArray();
        }
    }

    protected GroupBoundaries getGroupBoundaries() {
        return this.ast.createGroupBoundaries(this.getCaptureGroupUpdates(), this.getCaptureGroupClears(), this.getLastGroup());
    }

    private boolean doAdvance() {
        if (this.cur.isDead() || !this.ast.getOptions().getFlavor().canHaveEmptyLoopIterations() && this.cur.isGroupWithGuards() && this.insideLoops.contains(this.cur.asGroup())) {
            return this.retreat();
        }
        if (this.cur.isSequence()) {
            Sequence sequence = (Sequence)this.cur;
            if (sequence.isEmpty()) {
                Group parent = sequence.getParent();
                if (sequence.isQuantifierPassThroughSequence()) {
                    assert (this.pathGetNode(this.curPath.peek()) == parent && NFATraversalRegexASTVisitor.pathIsGroupEnter(this.curPath.peek()));
                    this.switchEnterToPassThrough(parent);
                    if (this.shouldRetreat) {
                        return this.retreat();
                    }
                    if (parent.isLoop()) {
                        this.unregisterInsideLoop(parent);
                    }
                } else {
                    this.pushGroupExit(parent);
                    if (this.shouldRetreat) {
                        return this.retreat();
                    }
                }
                return this.advanceTerm(parent);
            }
            this.cur = this.forward ? sequence.getFirstTerm() : sequence.getLastTerm();
            return false;
        }
        if (this.cur.isGroup()) {
            Group group = (Group)this.cur;
            this.pushGroupEnter(group, 1);
            if (this.shouldRetreat) {
                return this.retreat();
            }
            if (group.hasEmptyGuard()) {
                this.insideEmptyGuardGroup.set(group.getGroupsWithGuardsIndex());
            }
            if (group.isLoop()) {
                this.registerInsideLoop(group);
            }
            this.cur = group.getFirstAlternative();
            return this.deduplicatePath(true);
        }
        this.curPath.add(NFATraversalRegexASTVisitor.createPathElement(this.cur));
        if (this.cur.isPositionAssertion()) {
            PositionAssertion assertion = (PositionAssertion)this.cur;
            switch (assertion.type) {
                case CARET: {
                    ++this.caretsOnPath;
                    if (this.canTraverseCaret) {
                        return this.advanceTerm(assertion);
                    }
                    return this.retreat();
                }
                case DOLLAR: {
                    ++this.dollarsOnPath;
                    return this.advanceTerm((Term)this.cur);
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
        if (this.canTraverseLookArounds() && this.cur.isLookAheadAssertion()) {
            this.enterLookAhead((LookAheadAssertion)this.cur);
            this.addLookAroundToVisitedSet();
            return this.advanceTerm((Term)this.cur);
        }
        if (this.canTraverseLookArounds() && this.cur.isLookBehindAssertion()) {
            this.addLookAroundToVisitedSet();
            if (this.traversableLookBehindAssertions == null || this.traversableLookBehindAssertions.contains(this.cur)) {
                return this.advanceTerm((LookBehindAssertion)this.cur);
            }
            return this.retreat();
        }
        assert (this.cur.isCharacterClass() || this.cur.isBackReference() || this.cur.isMatchFound() || this.cur.isAtomicGroup() || !this.canTraverseLookArounds() && this.cur.isLookAroundAssertion());
        if ((this.forward && this.dollarsOnPath() || !this.forward && this.caretsOnPath()) && this.cur.isCharacterClass()) {
            return this.retreat();
        }
        return true;
    }

    private boolean advanceTerm(Term term) {
        if (this.ast.isNFAInitialState(term) || term.getParent().isSubtreeRoot() && (term.isPositionAssertion() || term.isMatchFound())) {
            assert (term.isPositionAssertion() || term.isMatchFound());
            this.cur = term.isPositionAssertion() ? term.asPositionAssertion().getNext() : term.asMatchFound().getNext();
            return false;
        }
        Term curTerm = term;
        while (!curTerm.getParent().isSubtreeRoot()) {
            if (curTerm.isGroupWithGuards() && this.insideEmptyGuardGroup.get(curTerm.asGroup().getGroupsWithGuardsIndex()) && (!this.ast.getOptions().getFlavor().canHaveEmptyLoopIterations() || !this.isBuildingDFA())) {
                return this.advanceEmptyGuard(curTerm);
            }
            Sequence parentSeq = (Sequence)curTerm.getParent();
            if (curTerm == (this.forward ? parentSeq.getLastTerm() : parentSeq.getFirstTerm())) {
                Group parentGroup = parentSeq.getParent();
                this.pushGroupExit(parentGroup);
                if (this.shouldRetreat) {
                    return this.retreat();
                }
                if (parentGroup.isLoop()) {
                    this.cur = parentGroup;
                    return false;
                }
                curTerm = parentGroup;
                continue;
            }
            this.cur = parentSeq.getTerms().get(curTerm.getSeqIndex() + (this.forward ? 1 : -1));
            return false;
        }
        assert (curTerm.isGroup());
        assert (curTerm.getParent().isSubtreeRoot());
        this.cur = curTerm.getSubTreeParent().getMatchFound();
        return false;
    }

    private boolean advanceEmptyGuard(Term curTerm) {
        if (this.ast.getOptions().getFlavor().canHaveEmptyLoopIterations() || curTerm.isQuantifiableTerm() && curTerm.asQuantifiableTerm().hasNotUnrolledQuantifier() && curTerm.asQuantifiableTerm().getQuantifier().getMin() > 0) {
            assert (curTerm.isGroup());
            this.cur = curTerm;
            return true;
        }
        return this.retreat();
    }

    private boolean retreat() {
        this.shouldRetreat = false;
        while (!this.curPath.isEmpty()) {
            long lastVisited = this.curPath.peek();
            RegexASTNode node = this.pathGetNode(lastVisited);
            if (NFATraversalRegexASTVisitor.pathIsGroup(lastVisited)) {
                Group group = (Group)node;
                if (NFATraversalRegexASTVisitor.pathIsGroupEnter(lastVisited) || NFATraversalRegexASTVisitor.pathIsGroupPassThrough(lastVisited)) {
                    if (this.pathGroupHasNext(lastVisited)) {
                        if (NFATraversalRegexASTVisitor.pathIsGroupPassThrough(lastVisited) && group.isLoop()) {
                            this.registerInsideLoop(group);
                        }
                        this.switchNextGroupAlternative(group);
                        if (this.shouldRetreat) {
                            return this.retreat();
                        }
                        this.cur = this.pathGroupGetNext(lastVisited);
                        return this.deduplicatePath(true);
                    }
                    if (NFATraversalRegexASTVisitor.pathIsGroupEnter(lastVisited)) {
                        this.popGroupEnter();
                    } else {
                        assert (NFATraversalRegexASTVisitor.pathIsGroupPassThrough(lastVisited));
                        this.popGroupPassThrough();
                    }
                    if (NFATraversalRegexASTVisitor.pathIsGroupEnter(lastVisited) && group.isLoop()) {
                        this.unregisterInsideLoop(group);
                    }
                    if (!group.hasEmptyGuard()) continue;
                    this.insideEmptyGuardGroup.clear(group.getGroupsWithGuardsIndex());
                    continue;
                }
                if (this.ast.getOptions().getFlavor().failingEmptyChecksDontBacktrack() && NFATraversalRegexASTVisitor.pathIsGroupExit(lastVisited) && group.hasQuantifier() && group.getQuantifier().hasZeroWidthIndex()) {
                    this.switchExitToEscape(group);
                    if (this.shouldRetreat) {
                        return this.retreat();
                    }
                    Group parentGroup = group.getParent().getParent().asGroup();
                    this.pushGroupExit(parentGroup);
                    return this.advanceTerm(parentGroup);
                }
                if (NFATraversalRegexASTVisitor.pathIsGroupExit(lastVisited)) {
                    this.popGroupExit();
                    continue;
                }
                assert (NFATraversalRegexASTVisitor.pathIsGroupEscape(lastVisited));
                this.popGroupEscape(group);
                continue;
            }
            this.curPath.pop();
            if (this.canTraverseLookArounds() && node.isLookAroundAssertion()) {
                if (node.isLookAheadAssertion()) {
                    this.leaveLookAhead(node.asLookAheadAssertion());
                }
                this.removeLookAroundFromVisitedSet(lastVisited);
                continue;
            }
            if (node.isDollar()) {
                --this.dollarsOnPath;
                continue;
            }
            if (!node.isCaret()) continue;
            --this.caretsOnPath;
        }
        this.done = true;
        return false;
    }

    private boolean deduplicatePath(boolean internal) {
        boolean isDuplicate;
        this.calcTransitionGuards();
        if (this.shouldRetreat) {
            return this.retreat();
        }
        assert (internal == this.cur.isSequence());
        boolean captureGroupsMatter = !this.cur.isMatchFound() && (this.ast.getOptions().getFlavor().backreferencesToUnmatchedGroupsFail() && this.ast.getProperties().hasBackReferences() || this.isBuildingDFA() && this.ast.getProperties().hasConditionalBackReferences());
        long id = this.cur.getId();
        if (this.caretsOnPath()) {
            id |= 0x100000000L;
        }
        if (this.dollarsOnPath()) {
            id |= 0x200000000L;
        }
        this.dedupKey.clear();
        this.dedupKey.add(id);
        this.dedupKey.addAll(this.lookAroundsOnPath.getInternalArray());
        if (internal) {
            this.dedupKey.addAll(this.insideEmptyGuardGroup.getInternalArray());
        }
        if (captureGroupsMatter) {
            this.dedupKeyAddGroupBoundaries(this.getCaptureGroupUpdates());
            this.dedupKeyAddGroupBoundaries(this.getCaptureGroupClears());
        }
        PrimitiveIterator.OfLong ofLong = this.getTransitionGuards().iterator();
        while (ofLong.hasNext()) {
            long guard = (Long)ofLong.next();
            if (TransitionGuard.is(guard, TransitionGuard.Kind.updateCG)) continue;
            this.dedupKey.add(guard);
        }
        DeduplicationKey key = new DeduplicationKey(this.dedupKey.toArray());
        boolean bl = isDuplicate = !this.pathDeduplicationSet.add((Object)key);
        if (isDuplicate) {
            return this.retreat();
        }
        return !internal;
    }

    private void dedupKeyAddGroupBoundaries(TBitSet boundaries) {
        long[] bitset = boundaries.getInternalArray();
        long[] referenced = this.referencedGroupBoundaries.getInternalArray();
        assert (bitset.length == referenced.length);
        for (int i = 0; i < bitset.length; ++i) {
            this.dedupKey.add(bitset[i] & referenced[i]);
        }
    }

    private static long createPathElement(RegexASTNode node) {
        return (long)node.getId() << 16;
    }

    private static int pathGetNodeId(long pathElement) {
        return (int)(pathElement >>> 16);
    }

    private RegexASTNode pathGetNode(long pathElement) {
        return this.ast.getState(NFATraversalRegexASTVisitor.pathGetNodeId(pathElement));
    }

    private static int pathGetGroupAltIndex(long pathElement) {
        return (short)(pathElement >>> 0);
    }

    private static boolean pathIsGroup(long pathElement) {
        return (pathElement & 0xF000000000000L) != 0L;
    }

    private static boolean pathIsGroupEnter(long pathElement) {
        return (pathElement & 0x1000000000000L) != 0L;
    }

    private static boolean pathIsGroupExit(long pathElement) {
        return (pathElement & 0x2000000000000L) != 0L;
    }

    private static boolean pathIsGroupPassThrough(long pathElement) {
        return (pathElement & 0x4000000000000L) != 0L;
    }

    private static boolean pathIsGroupEscape(long pathElement) {
        return (pathElement & 0x8000000000000L) != 0L;
    }

    private static boolean pathIsGroupExitOrEscape(long pathElement) {
        return (pathElement & 0xA000000000000L) != 0L;
    }

    private boolean pathGroupHasNext(long pathElement) {
        return NFATraversalRegexASTVisitor.pathGetGroupAltIndex(pathElement) < ((Group)this.pathGetNode(pathElement)).size();
    }

    private Sequence pathGroupGetNext(long pathElement) {
        return ((Group)this.pathGetNode(pathElement)).getAlternatives().get(NFATraversalRegexASTVisitor.pathGetGroupAltIndex(pathElement));
    }

    private void pushGroupEnter(Group group, int groupAltIndex) {
        this.curPath.add(NFATraversalRegexASTVisitor.createPathElement(group) | (long)(groupAltIndex << 0) | 0x1000000000000L);
        this.recalcTransitionGuards = true;
    }

    private int popGroupEnter() {
        long pathEntry = this.curPath.pop();
        assert (NFATraversalRegexASTVisitor.pathIsGroupEnter(pathEntry));
        this.recalcTransitionGuards = true;
        return NFATraversalRegexASTVisitor.pathGetGroupAltIndex(pathEntry);
    }

    private void switchNextGroupAlternative(Group group) {
        int groupAltIndex;
        if (NFATraversalRegexASTVisitor.pathIsGroupEnter(this.curPath.peek())) {
            groupAltIndex = this.popGroupEnter();
        } else {
            assert (NFATraversalRegexASTVisitor.pathIsGroupPassThrough(this.curPath.peek()));
            groupAltIndex = this.popGroupPassThrough();
        }
        this.pushGroupEnter(group, groupAltIndex + 1);
    }

    private void pushGroupExit(Group group) {
        this.curPath.add(NFATraversalRegexASTVisitor.createPathElement(group) | 0x2000000000000L);
        this.recalcTransitionGuards = true;
    }

    private void popGroupExit() {
        long pathEntry = this.curPath.pop();
        assert (NFATraversalRegexASTVisitor.pathIsGroupExit(pathEntry));
        this.recalcTransitionGuards = true;
    }

    private void pushGroupPassThrough(Group group, int groupAltIndex) {
        this.curPath.add(NFATraversalRegexASTVisitor.createPathElement(group) | 0x4000000000000L | (long)(groupAltIndex << 0));
        this.recalcTransitionGuards = true;
    }

    private int popGroupPassThrough() {
        long pathEntry = this.curPath.pop();
        int groupAltIndex = NFATraversalRegexASTVisitor.pathGetGroupAltIndex(pathEntry);
        assert (NFATraversalRegexASTVisitor.pathIsGroupPassThrough(pathEntry));
        this.recalcTransitionGuards = true;
        return groupAltIndex;
    }

    private void switchEnterToPassThrough(Group group) {
        int groupAltIndex = this.popGroupEnter();
        this.pushGroupPassThrough(group, groupAltIndex);
    }

    private void switchExitToEscape(Group group) {
        this.popGroupExit();
        this.pushGroupEscape(group);
    }

    private void pushGroupEscape(Group group) {
        this.curPath.add(NFATraversalRegexASTVisitor.createPathElement(group) | 0x8000000000000L);
        this.recalcTransitionGuards = true;
    }

    private void popGroupEscape(Group group) {
        long pathEntry = this.curPath.pop();
        assert (NFATraversalRegexASTVisitor.pathIsGroupEscape(pathEntry));
        assert (group == this.pathGetNode(pathEntry));
        this.recalcTransitionGuards = true;
    }

    private void clearCaptureGroupData() {
        this.captureGroupUpdates.clear();
        this.captureGroupClears.clear();
        this.lastGroup = -1;
    }

    private TBitSet getCaptureGroupUpdates() {
        this.calcTransitionGuards();
        return this.captureGroupUpdates;
    }

    private TBitSet getCaptureGroupClears() {
        this.calcTransitionGuards();
        return this.captureGroupClears;
    }

    private int getLastGroup() {
        this.calcTransitionGuards();
        return this.lastGroup;
    }

    private LongArrayBuffer getTransitionGuards() {
        this.calcTransitionGuards();
        return this.transitionGuards;
    }

    private void calcTransitionGuards() {
        if (this.recalcTransitionGuards) {
            if (this.useTransitionGuards()) {
                this.calculateTransitionGuards();
            } else {
                this.calculateGroupBoundaries();
            }
            this.recalcTransitionGuards = false;
        }
    }

    private void calculateGroupBoundaries() {
        this.clearCaptureGroupData();
        PrimitiveIterator.OfLong ofLong = this.curPath.iterator();
        while (ofLong.hasNext()) {
            long element = (Long)ofLong.next();
            if (!NFATraversalRegexASTVisitor.pathIsGroup(element)) continue;
            Group group = (Group)this.pathGetNode(element);
            if (NFATraversalRegexASTVisitor.pathIsGroupEnter(element)) {
                this.calcGroupBoundariesEnter(group);
                continue;
            }
            if (!NFATraversalRegexASTVisitor.pathIsGroupExitOrEscape(element)) continue;
            this.calcGroupBoundariesExit(group);
        }
    }

    private int getBoundaryIndexStart(Group group) {
        return this.forward ? group.getBoundaryIndexStart() : group.getBoundaryIndexEnd();
    }

    private int getBoundaryIndexEnd(Group group) {
        return this.forward ? group.getBoundaryIndexEnd() : group.getBoundaryIndexStart();
    }

    private void calcGroupBoundariesEnter(Group group) {
        if (group.isCapturing()) {
            this.captureGroupUpdate(this.getBoundaryIndexStart(group));
        }
        if (!this.ast.getOptions().getFlavor().nestedCaptureGroupsKeptOnLoopReentry() && group.hasQuantifier() && group.hasEnclosedCaptureGroups()) {
            int lo = Group.groupNumberToBoundaryIndexStart(group.getEnclosedCaptureGroupsLow());
            int hi = Group.groupNumberToBoundaryIndexEnd(group.getEnclosedCaptureGroupsHigh() - 1);
            this.captureGroupClears.setRange(lo, hi);
            this.captureGroupUpdates.clearRange(lo, hi);
        }
    }

    private void calcGroupBoundariesExit(Group group) {
        if (group.isCapturing()) {
            this.captureGroupUpdate(this.getBoundaryIndexEnd(group));
            if (this.ast.getOptions().getFlavor().usesLastGroupResultField() && group.getGroupNumber() != 0) {
                this.lastGroup = group.getGroupNumber();
            }
        }
    }

    private void captureGroupUpdate(int boundary) {
        this.captureGroupUpdates.set(boundary);
        this.captureGroupClears.clear(boundary);
    }

    private void calculateTransitionGuards() {
        this.clearCaptureGroupData();
        this.boundedQuantifiersLoop.clear();
        this.boundedQuantifiersExited.clear();
        this.transitionGuards.clear();
        PrimitiveIterator.OfLong ofLong = this.curPath.iterator();
        while (ofLong.hasNext()) {
            Token.Quantifier quantifier;
            long element = (Long)ofLong.next();
            if (!NFATraversalRegexASTVisitor.pathIsGroup(element)) continue;
            Group group = (Group)this.pathGetNode(element);
            int groupAltIndex = NFATraversalRegexASTVisitor.pathGetGroupAltIndex(element);
            if (NFATraversalRegexASTVisitor.pathIsGroupEnter(element)) {
                if (group.hasQuantifier()) {
                    quantifier = group.getQuantifier();
                    if (quantifier.hasIndex()) {
                        if (!quantifier.isInfiniteLoop() && this.boundedQuantifiersLoop.get(quantifier.getIndex()) && !this.boundedQuantifiersExited.get(quantifier.getIndex())) {
                            this.pushTransitionGuard(TransitionGuard.createLoop(quantifier));
                        } else {
                            this.pushTransitionGuard(TransitionGuard.createLoopInc(quantifier));
                        }
                    }
                    if (this.needsEmptyCheck(group)) {
                        this.pushTransitionGuard(TransitionGuard.createEnterZeroWidth(quantifier));
                    }
                }
                if (this.needsUpdateCGStepByStep(group) && !this.captureGroupUpdates.get(this.getBoundaryIndexStart(group))) {
                    this.pushTransitionGuard(TransitionGuard.createUpdateCG(this.getBoundaryIndexStart(group)));
                }
                this.calcGroupBoundariesEnter(group);
                if (!group.isConditionalBackReferenceGroup()) continue;
                this.pushTransitionGuard(NFATraversalRegexASTVisitor.getConditionalBackReferenceGroupTransitionGuard(group, groupAltIndex));
                continue;
            }
            if (NFATraversalRegexASTVisitor.pathIsGroupExitOrEscape(element)) {
                if (NFATraversalRegexASTVisitor.pathIsGroupExit(element)) {
                    if (group.hasQuantifier()) {
                        quantifier = group.getQuantifier();
                        if (quantifier.hasIndex()) {
                            this.boundedQuantifiersLoop.set(quantifier.getIndex());
                        }
                        if (this.needsEmptyCheck(group)) {
                            this.pushTransitionGuard(TransitionGuard.createExitZeroWidth(quantifier));
                        }
                    }
                    this.pushRecursiveBackrefUpdates(group);
                } else if (NFATraversalRegexASTVisitor.pathIsGroupEscape(element) && group.hasQuantifier()) {
                    quantifier = group.getQuantifier();
                    if (quantifier.hasIndex()) {
                        this.boundedQuantifiersExited.set(quantifier.getIndex());
                        this.pushTransitionGuard(TransitionGuard.createExitReset(quantifier));
                    }
                    if (quantifier.hasZeroWidthIndex()) {
                        this.pushTransitionGuard(TransitionGuard.createEscapeZeroWidth(quantifier));
                    }
                }
                if (this.needsUpdateCGStepByStep(group) && !this.captureGroupUpdates.get(this.getBoundaryIndexEnd(group))) {
                    this.pushTransitionGuard(TransitionGuard.createUpdateCG(this.getBoundaryIndexEnd(group)));
                }
                this.calcGroupBoundariesExit(group);
                continue;
            }
            if (!NFATraversalRegexASTVisitor.pathIsGroupPassThrough(element)) continue;
            Group quantifierGroup = NFATraversalRegexASTVisitor.getQuantifiedGroupFromPassthrough(group, groupAltIndex);
            Token.Quantifier quantifier2 = quantifierGroup.getQuantifier();
            if (quantifierGroup.isExpandedQuantifier()) continue;
            if (quantifier2.hasIndex()) {
                if (quantifier2.getMin() > 0) {
                    this.boundedQuantifiersExited.set(quantifier2.getIndex());
                    this.pushTransitionGuard(TransitionGuard.createExit(quantifier2));
                    continue;
                }
                this.pushTransitionGuard(TransitionGuard.createExitReset(quantifier2));
                continue;
            }
            assert (quantifierGroup.isDead());
            if (quantifier2.getMin() <= 0) continue;
            this.shouldRetreat = true;
        }
    }

    private static Group getQuantifiedGroupFromPassthrough(Group group, int groupAltIndex) {
        assert (group.size() == 2 && groupAltIndex - 1 >= 0 && groupAltIndex - 1 <= 1);
        int otherAltIndex = groupAltIndex - 1 ^ 1;
        Sequence otherAlternative = group.getAlternatives().get(otherAltIndex);
        assert (!otherAlternative.isEmpty() && otherAlternative.get(0).isGroup());
        Group quantifierGroup = otherAlternative.get(0).asGroup();
        assert (quantifierGroup.hasQuantifier());
        return quantifierGroup;
    }

    private boolean needsUpdateCGStepByStep(Group group) {
        return this.ast.getOptions().getFlavor().matchesTransitionsStepByStep() && group.isCapturing();
    }

    private boolean needsEmptyCheck(Group group) {
        assert (group.hasQuantifier());
        return group.getQuantifier().hasZeroWidthIndex() && (this.ast.getOptions().getFlavor().emptyChecksOnMandatoryLoopIterations() || !group.isMandatoryUnrolledQuantifier());
    }

    private static long getConditionalBackReferenceGroupTransitionGuard(Group group, int groupAltIndex) {
        assert (group.isConditionalBackReferenceGroup());
        int referencedGroupNumber = group.asConditionalBackReferenceGroup().getReferencedGroupNumber();
        if (groupAltIndex == 1) {
            return TransitionGuard.createCheckGroupMatched(referencedGroupNumber);
        }
        assert (groupAltIndex == 2);
        return TransitionGuard.createCheckGroupNotMatched(referencedGroupNumber);
    }

    private void pushRecursiveBackrefUpdates(Group group) {
        if (this.ast.getOptions().getFlavor().supportsRecursiveBackreferences() && this.ast.getProperties().hasRecursiveBackReferences() && group.isCapturing() && this.ast.isGroupRecursivelyReferenced(group.getGroupNumber())) {
            this.pushTransitionGuard(TransitionGuard.createUpdateRecursiveBackref(group.getGroupNumber()));
        }
    }

    private boolean useTransitionGuards() {
        return !this.isBuildingDFA() || this.ast.getOptions().getFlavor().canHaveEmptyLoopIterations();
    }

    private void clearTransitionGuards() {
        this.transitionGuards.clear();
    }

    private void pushTransitionGuard(long guard) {
        assert (this.useTransitionGuards());
        block0 : switch (TransitionGuard.getKind(guard)) {
            case exitZeroWidth: 
            case escapeZeroWidth: {
                boolean keptAlive;
                boolean keptAliveByConsumedInput = false;
                boolean keptAliveByCaptureGroups = false;
                if (!this.transitionGuards.isEmpty() && this.transitionGuards.peek() == guard) {
                    return;
                }
                long enter = TransitionGuard.createEnterZeroWidthFromExit(guard);
                boolean enterFound = false;
                for (int i = this.transitionGuards.length() - 1; i >= 0; --i) {
                    long tg = this.transitionGuards.get(i);
                    if (tg == enter) {
                        enterFound = true;
                        break;
                    }
                    if (!this.ast.getOptions().getFlavor().emptyChecksMonitorCaptureGroups() || !TransitionGuard.is(tg, TransitionGuard.Kind.updateCG)) continue;
                    keptAliveByCaptureGroups = true;
                }
                if (!enterFound) {
                    keptAliveByConsumedInput = this.isBuildingDFA() || this.root.isCharacterClass();
                }
                boolean bl = keptAlive = keptAliveByConsumedInput || keptAliveByCaptureGroups;
                if (!this.isBuildingDFA()) break;
                if (TransitionGuard.is(guard, TransitionGuard.Kind.exitZeroWidth) && !keptAlive || TransitionGuard.is(guard, TransitionGuard.Kind.escapeZeroWidth) && keptAlive) {
                    this.shouldRetreat = true;
                }
                return;
            }
            case enterZeroWidth: {
                for (int i = this.transitionGuards.length() - 1; i >= 0; --i) {
                    long tg = this.transitionGuards.get(i);
                    if (this.ast.getOptions().getFlavor().emptyChecksMonitorCaptureGroups() && TransitionGuard.is(tg, TransitionGuard.Kind.updateCG)) break block0;
                    if (tg != guard) continue;
                    return;
                }
                break;
            }
            case checkGroupMatched: 
            case checkGroupNotMatched: {
                boolean groupMatched;
                assert ((this.isBuildingDFA() && this.getMatchedConditionGroups() != null) == this instanceof ASTStepVisitor);
                if (!this.isBuildingDFA() || this.getMatchedConditionGroups() == null) break;
                int referencedGroupNumber = TransitionGuard.getGroupNumber(guard);
                int groupEndIndex = Group.groupNumberToBoundaryIndexEnd(referencedGroupNumber);
                boolean bl = groupMatched = this.getMatchedConditionGroups().get(referencedGroupNumber) && !this.captureGroupClears.get(groupEndIndex) || this.captureGroupUpdates.get(groupEndIndex);
                if (TransitionGuard.is(guard, TransitionGuard.Kind.checkGroupMatched) != groupMatched) {
                    this.shouldRetreat = true;
                }
                return;
            }
        }
        this.transitionGuards.add(guard);
    }

    private void addLookAroundToVisitedSet() {
        LookAroundAssertion la = (LookAroundAssertion)this.cur;
        int n = la.getGlobalSubTreeId();
        this.lookAroundVisitiedCount[n] = this.lookAroundVisitiedCount[n] + 1;
        this.lookAroundsOnPath.set(la.getGlobalSubTreeId());
    }

    private void removeLookAroundFromVisitedSet(long pathElement) {
        LookAroundAssertion la = (LookAroundAssertion)this.pathGetNode(pathElement);
        int n = la.getGlobalSubTreeId();
        this.lookAroundVisitiedCount[n] = this.lookAroundVisitiedCount[n] - 1;
        if (this.lookAroundVisitiedCount[n] == 0) {
            this.lookAroundsOnPath.clear(la.getGlobalSubTreeId());
        }
    }

    private boolean nodeVisitsEmpty() {
        for (int i : this.lookAroundVisitiedCount) {
            if (i == 0) continue;
            return false;
        }
        return true;
    }

    private void registerInsideLoop(Group group) {
        if (!this.ast.getOptions().getFlavor().canHaveEmptyLoopIterations()) {
            this.insideLoops.add(group);
        }
    }

    private void unregisterInsideLoop(Group group) {
        if (!this.ast.getOptions().getFlavor().canHaveEmptyLoopIterations()) {
            this.insideLoops.remove(group);
        }
    }

    private void dumpPath() {
        System.out.println("NEW PATH");
        for (int i = 0; i < this.curPath.length(); ++i) {
            long element = this.curPath.get(i);
            if (NFATraversalRegexASTVisitor.pathIsGroup(element)) {
                Group group = (Group)this.pathGetNode(element);
                if (NFATraversalRegexASTVisitor.pathIsGroupEnter(element)) {
                    System.out.printf("ENTER (%d)   %s%n", NFATraversalRegexASTVisitor.pathGetGroupAltIndex(element), group);
                    continue;
                }
                if (NFATraversalRegexASTVisitor.pathIsGroupExit(element)) {
                    System.out.printf("EXIT        %s%n", group);
                    continue;
                }
                if (NFATraversalRegexASTVisitor.pathIsGroupPassThrough(element)) {
                    System.out.printf("PASSTHROUGH %s%n", group);
                    continue;
                }
                System.out.printf("ESCAPE      %s%n", group);
                continue;
            }
            System.out.printf("NODE        %s%n", this.pathGetNode(element));
        }
    }

    protected void dumpTransitionGuards(long[] guards) {
        for (long guard : guards) {
            System.out.println(TransitionGuard.toString(guard));
        }
    }

    private static final class DeduplicationKey {
        private final long[] key;
        private final int hashCode;

        DeduplicationKey(long[] key) {
            this.key = key;
            this.hashCode = Arrays.hashCode(key);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeduplicationKey)) {
                return false;
            }
            DeduplicationKey other = (DeduplicationKey)obj;
            return Arrays.equals(this.key, other.key);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

