/*
 * Decompiled with CFR 0.152.
 */
package org.mule.sdk.api.values;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.util.Preconditions;
import org.mule.sdk.api.annotation.DoNotEnforceMinMuleVersion;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.values.Value;
import org.mule.sdk.internal.values.ImmutableValue;

@MinMuleVersion(value="4.4")
@DoNotEnforceMinMuleVersion
public class ValueBuilder {
    private final String id;
    private final Set<ValueBuilder> childs = new LinkedHashSet<ValueBuilder>();
    private String displayName;
    private String partName = "";

    private ValueBuilder(String id) {
        this.id = id;
    }

    private ValueBuilder(String id, String partName) {
        this.id = id;
        this.partName = partName;
    }

    public static ValueBuilder newValue(String id) {
        Preconditions.checkArgument((boolean)ValueBuilder.isNotEmpty(id), (String)"The ID can't be empty");
        return new ValueBuilder(id);
    }

    public static ValueBuilder newValue(String id, String partName) {
        Preconditions.checkArgument((boolean)ValueBuilder.isNotEmpty(id), (String)"The ID can't be empty");
        return new ValueBuilder(id, partName);
    }

    public static Set<Value> getValuesFor(String ... values) {
        return ValueBuilder.getValuesFor(Arrays.stream(values));
    }

    public static Set<Value> getValuesFor(List<String> values) {
        return ValueBuilder.getValuesFor(values.stream());
    }

    public static Set<Value> getValuesFor(Stream<String> values) {
        return values.map(id -> {
            Preconditions.checkArgument((boolean)ValueBuilder.isNotEmpty(id), (String)"The ID can't be empty");
            return id;
        }).map(ValueBuilder::newValue).map(ValueBuilder::build).collect(Collectors.toSet());
    }

    public static Set<Value> getValuesFor(Map<String, String> values) {
        return values.entrySet().stream().map(entry -> {
            Preconditions.checkArgument((boolean)ValueBuilder.isNotEmpty((String)entry.getKey()), (String)"The ID can't be empty");
            Preconditions.checkArgument((boolean)ValueBuilder.isNotEmpty((String)entry.getValue()), (String)"The displayName can't be empty");
            return ValueBuilder.newValue((String)entry.getKey()).withDisplayName((String)entry.getValue()).build();
        }).collect(Collectors.toSet());
    }

    public ValueBuilder withDisplayName(String displayName) {
        Preconditions.checkArgument((boolean)ValueBuilder.isNotEmpty(displayName), (String)"The displayName can't be empty");
        this.displayName = displayName;
        return this;
    }

    public ValueBuilder withChild(ValueBuilder valueBuilder) {
        this.childs.add(valueBuilder);
        return this;
    }

    protected void setPartName(String partName) {
        this.partName = partName;
    }

    public Value build() {
        String name = ValueBuilder.isNotEmpty(this.displayName) ? this.displayName : this.id;
        return new ImmutableValue(this.id, name, this.childs.stream().map(ValueBuilder::build).collect(Collectors.toCollection(LinkedHashSet::new)), this.partName);
    }

    private static boolean isNotEmpty(String description) {
        return description != null && !description.isEmpty();
    }
}

