/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.object.EconomicTransitionMap;
import com.oracle.truffle.object.ObjectStorageOptions;
import com.oracle.truffle.object.ShapeImpl;
import com.oracle.truffle.object.StrongKeyWeakValueEntry;
import com.oracle.truffle.object.TrieTransitionMap;
import com.oracle.truffle.object.WeakKey;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import java.util.function.BiConsumer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class TransitionMap<K, V> {
    protected final ReferenceQueue<V> queue = new ReferenceQueue();

    TransitionMap() {
    }

    public static <K, V> TransitionMap<K, V> create() {
        if (ObjectStorageOptions.TrieTransitionMap) {
            return new TrieTransitionMap();
        }
        return new EconomicTransitionMap();
    }

    public final boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    protected final V getValue(Map.Entry<? super K, V> entry) {
        return entry == null ? null : (V)entry.getValue();
    }

    public abstract V get(Object var1);

    protected abstract V putAnyKey(Object var1, V var2);

    protected abstract V putAnyKeyIfAbsent(Object var1, V var2);

    public final V put(K key, V value) {
        return this.putAnyKey(key, value);
    }

    public final V putIfAbsent(K key, V value) {
        return this.putAnyKeyIfAbsent(key, value);
    }

    public final V putWeakKey(K key, V value) {
        ShapeImpl.shapeCacheWeakKeys.inc();
        WeakKey<K> weakKey = new WeakKey<K>(key);
        return this.putAnyKey(weakKey, value);
    }

    public final V putWeakKeyIfAbsent(K key, V value) {
        ShapeImpl.shapeCacheWeakKeys.inc();
        WeakKey<K> weakKey = new WeakKey<K>(key);
        return this.putAnyKeyIfAbsent(weakKey, value);
    }

    public abstract V remove(Object var1);

    protected final void expungeStaleEntries() {
        Reference<V> r;
        while ((r = this.queue.poll()) != null) {
            if (!(r instanceof StrongKeyWeakValueEntry)) continue;
            StrongKeyWeakValueEntry entry = (StrongKeyWeakValueEntry)r;
            this.expungeStaleEntry(entry);
            ShapeImpl.shapeCacheExpunged.inc();
        }
    }

    protected abstract void expungeStaleEntry(StrongKeyWeakValueEntry<Object, V> var1);

    public abstract void forEach(BiConsumer<? super K, ? super V> var1);

    protected final K unwrapKey(Object key) {
        if (key instanceof WeakKey) {
            return (K)((WeakKey)key).get();
        }
        return (K)key;
    }
}

