/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.core.xml.reader.indexed;

import org.mule.weave.v2.module.core.common.TokenHelper;
import org.mule.weave.v2.module.core.common.TokenHelper$;
import org.mule.weave.v2.module.core.xml.reader.indexed.LongUtils$;
import org.mule.weave.v2.module.core.xml.reader.indexed.XmlTokenType$;
import scala.Enumeration;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class XmlTokenHelper$
implements TokenHelper {
    public static XmlTokenHelper$ MODULE$;
    private final int OFFSET_LEN;
    private final long MAX_OFFSET;
    private final int DEPTH_LEN;
    private final long MAX_DEPTH;
    private final int TOKEN_TYPE_LEN;
    private final int HASH_LEN;
    private final int NS_INDEX_LEN;
    private final long MAX_NS;
    private final int QNAME_LEN;
    private final long MAX_QNAME;
    private final int LENGTH_LEN;
    private final long MAX_LENGTH;
    private final int OFFSET_RIGHT_BITS;
    private final int DEPTH_RIGHT_BITS;
    private final int TOKEN_TYPE_RIGHT_BITS;
    private final int HASH_RIGHT_BITS;
    private final int NS_INDEX_RIGHT_BITS;
    private final long MASK_OFFSET;
    private final long MASK_DEPTH;
    private final long MASK_TOKEN_TYPE;
    private final long MASK_HASH;
    private final long MASK_NS_INDEX;
    private final long MASK_QNAME_LEN;
    private final long MASK_FULL_LEN;
    private final int NO_NAMESPACE;
    private final int NO_OFFSET_HASH_MASK;
    private final Seq<Object> typesWithNs;

    static {
        new XmlTokenHelper$();
    }

    @Override
    public int OFFSET_LEN() {
        return this.OFFSET_LEN;
    }

    public long MAX_OFFSET() {
        return this.MAX_OFFSET;
    }

    public int DEPTH_LEN() {
        return this.DEPTH_LEN;
    }

    public long MAX_DEPTH() {
        return this.MAX_DEPTH;
    }

    public int TOKEN_TYPE_LEN() {
        return this.TOKEN_TYPE_LEN;
    }

    public int HASH_LEN() {
        return this.HASH_LEN;
    }

    public int NS_INDEX_LEN() {
        return this.NS_INDEX_LEN;
    }

    public long MAX_NS() {
        return this.MAX_NS;
    }

    public int QNAME_LEN() {
        return this.QNAME_LEN;
    }

    public long MAX_QNAME() {
        return this.MAX_QNAME;
    }

    public int LENGTH_LEN() {
        return this.LENGTH_LEN;
    }

    public long MAX_LENGTH() {
        return this.MAX_LENGTH;
    }

    public int OFFSET_RIGHT_BITS() {
        return this.OFFSET_RIGHT_BITS;
    }

    public int DEPTH_RIGHT_BITS() {
        return this.DEPTH_RIGHT_BITS;
    }

    public int TOKEN_TYPE_RIGHT_BITS() {
        return this.TOKEN_TYPE_RIGHT_BITS;
    }

    public int HASH_RIGHT_BITS() {
        return this.HASH_RIGHT_BITS;
    }

    public int NS_INDEX_RIGHT_BITS() {
        return this.NS_INDEX_RIGHT_BITS;
    }

    public long MASK_OFFSET() {
        return this.MASK_OFFSET;
    }

    public long MASK_DEPTH() {
        return this.MASK_DEPTH;
    }

    public long MASK_TOKEN_TYPE() {
        return this.MASK_TOKEN_TYPE;
    }

    public long MASK_HASH() {
        return this.MASK_HASH;
    }

    public long MASK_NS_INDEX() {
        return this.MASK_NS_INDEX;
    }

    public long MASK_QNAME_LEN() {
        return this.MASK_QNAME_LEN;
    }

    public long MASK_FULL_LEN() {
        return this.MASK_FULL_LEN;
    }

    public int NO_NAMESPACE() {
        return this.NO_NAMESPACE;
    }

    public int NO_OFFSET_HASH_MASK() {
        return this.NO_OFFSET_HASH_MASK;
    }

    public long lengthToMask(int len) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            builder.append("1");
        }
        String maskString = builder.toString();
        long l = LongUtils$.MODULE$.parseUnsignedLong(maskString, 2);
        return l;
    }

    public int hash(String str) {
        return str.hashCode() & this.NO_OFFSET_HASH_MASK();
    }

    public long firstLongToken(long offset, int depth) {
        long shiftedOffset = offset << this.OFFSET_RIGHT_BITS();
        long offsetDepthToken = shiftedOffset | (long)depth;
        return offsetDepthToken;
    }

    public long secondLongToken(Enumeration.Value tokenType, long length) {
        long tokenTypeLong = (long)tokenType.id() << this.TOKEN_TYPE_RIGHT_BITS();
        long typeLengthToken = tokenTypeLong | length;
        return typeLengthToken;
    }

    public Seq<Object> typesWithNs() {
        return this.typesWithNs;
    }

    public boolean hasNamespace(int tokenTypeId) {
        return this.typesWithNs().contains((Object)BoxesRunTime.boxToInteger((int)tokenTypeId));
    }

    @Override
    public int getTokenType(long[] longs) {
        long token = longs[1];
        return (int)((token & this.MASK_TOKEN_TYPE()) >>> this.TOKEN_TYPE_RIGHT_BITS());
    }

    public int get16BitHashCode(long[] longs) {
        return (int)((longs[1] & this.MASK_HASH()) >>> this.HASH_RIGHT_BITS());
    }

    @Override
    public long getOffset(long[] longs) {
        long token = longs[0];
        return (token & this.MASK_OFFSET()) >>> this.OFFSET_RIGHT_BITS();
    }

    public long getLength(long[] longs) {
        return longs[1] & this.MASK_FULL_LEN();
    }

    @Override
    public int getDepth(long[] longs) {
        return (int)((longs[0] & this.MASK_DEPTH()) >>> this.DEPTH_RIGHT_BITS());
    }

    @Override
    public int getNameHash(long[] longs) {
        return this.get16BitHashCode(longs);
    }

    @Override
    public long getKeyLength(long[] longs) {
        return this.getQnameLength(longs);
    }

    @Override
    public long getValueLength(long[] longs) {
        return this.getLength(longs);
    }

    public Option<Object> getNsIndex(long[] longs) {
        int nsIndex = (int)((longs[1] & this.MASK_NS_INDEX()) >>> this.NS_INDEX_RIGHT_BITS());
        if (nsIndex < this.NO_NAMESPACE()) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)nsIndex));
        }
        return None$.MODULE$;
    }

    public long getQnameLength(long[] longs) {
        return longs[1] & this.MASK_QNAME_LEN();
    }

    public boolean isStartElement(long[] longs) {
        return this.getTokenType(longs) == XmlTokenType$.MODULE$.StartElement().id();
    }

    public boolean isStartElementWithNull(long[] longs) {
        return this.getTokenType(longs) == XmlTokenType$.MODULE$.StartElementWithNull().id();
    }

    public boolean isAttributeName(long[] longs) {
        return this.getTokenType(longs) == XmlTokenType$.MODULE$.AttributeName().id();
    }

    public boolean isAttrNameRefType(long[] longs) {
        return this.getTokenType(longs) == XmlTokenType$.MODULE$.AttributeNameTypeRef().id();
    }

    public boolean isCdata(long[] longs) {
        return this.getTokenType(longs) == XmlTokenType$.MODULE$.Cdata().id();
    }

    public boolean isText(long[] longs) {
        return this.getTokenType(longs) == XmlTokenType$.MODULE$.Text().id();
    }

    public boolean isTextOrCdata(long[] longs) {
        return this.isText(longs) || this.isCdata(longs);
    }

    @Override
    public boolean shouldAddToLocationCache(long[] token) {
        return this.isStartElement(token) || this.isStartElementWithNull(token);
    }

    private XmlTokenHelper$() {
        MODULE$ = this;
        this.OFFSET_LEN = TokenHelper$.MODULE$.OFFSET_LEN();
        this.MAX_OFFSET = (long)Math.pow(2.0, this.OFFSET_LEN());
        this.DEPTH_LEN = 12;
        this.MAX_DEPTH = (long)Math.pow(2.0, this.DEPTH_LEN());
        this.TOKEN_TYPE_LEN = 4;
        this.HASH_LEN = 16;
        this.NS_INDEX_LEN = 14;
        this.MAX_NS = (long)Math.pow(2.0, this.NS_INDEX_LEN());
        this.QNAME_LEN = 30;
        this.MAX_QNAME = (long)Math.pow(2.0, this.QNAME_LEN());
        this.LENGTH_LEN = 60;
        this.MAX_LENGTH = (long)Math.pow(2.0, this.LENGTH_LEN());
        this.OFFSET_RIGHT_BITS = this.DEPTH_LEN();
        this.DEPTH_RIGHT_BITS = 0;
        this.TOKEN_TYPE_RIGHT_BITS = this.LENGTH_LEN();
        this.HASH_RIGHT_BITS = this.QNAME_LEN() + this.NS_INDEX_LEN();
        this.NS_INDEX_RIGHT_BITS = this.QNAME_LEN();
        this.MASK_OFFSET = this.lengthToMask(this.OFFSET_LEN()) << this.OFFSET_RIGHT_BITS();
        this.MASK_DEPTH = this.lengthToMask(this.DEPTH_LEN()) << this.DEPTH_RIGHT_BITS();
        this.MASK_TOKEN_TYPE = this.lengthToMask(this.TOKEN_TYPE_LEN()) << this.TOKEN_TYPE_RIGHT_BITS();
        this.MASK_HASH = this.lengthToMask(this.HASH_LEN()) << this.HASH_RIGHT_BITS();
        this.MASK_NS_INDEX = this.lengthToMask(this.NS_INDEX_LEN()) << this.NS_INDEX_RIGHT_BITS();
        this.MASK_QNAME_LEN = this.lengthToMask(this.QNAME_LEN());
        this.MASK_FULL_LEN = this.lengthToMask(this.LENGTH_LEN());
        this.NO_NAMESPACE = (int)this.lengthToMask(this.NS_INDEX_LEN());
        this.NO_OFFSET_HASH_MASK = (int)this.lengthToMask(this.HASH_LEN());
        this.typesWithNs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{XmlTokenType$.MODULE$.AttributeName().id(), XmlTokenType$.MODULE$.StartElement().id(), XmlTokenType$.MODULE$.StartElementWithNull().id()}));
    }
}

