/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.internal.loader.ExtensionModelFactory;
import org.mule.runtime.extension.privileged.loader.ProblemsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultProblemsHandler
implements ProblemsHandler {
    private ExtensionModel extensionModel;
    private final Logger LOGGER = LoggerFactory.getLogger(ExtensionModelFactory.class);

    DefaultProblemsHandler(ExtensionModel extensionModel) {
        this.extensionModel = extensionModel;
    }

    @Override
    public void handleProblems(ProblemsReporter problemsReporter) {
        if (problemsReporter.hasWarnings() && this.LOGGER.isWarnEnabled()) {
            this.LOGGER.warn(String.format("Extension '%s' has definition warnings:\n%s", this.extensionModel.getName(), problemsReporter.getWarningsAsString()));
        }
        if (problemsReporter.hasErrors()) {
            throw new IllegalModelDefinitionException(String.format("Extension '%s' has definition errors:\n%s", this.extensionModel.getName(), problemsReporter.toString()));
        }
    }
}

