/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.model.notification;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.util.Preconditions;

public final class ImmutableNotificationModel
implements NotificationModel {
    private final String namespace;
    private final String identifier;
    private final MetadataType metadataType;

    public ImmutableNotificationModel(String namespace, String identifier, MetadataType metadataType) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)namespace) ? 1 : 0) != 0, (String)"namespace cannot be blank");
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)identifier) ? 1 : 0) != 0, (String)"identifier cannot be blank");
        Preconditions.checkArgument((metadataType != null ? 1 : 0) != 0, (String)"type cannot be null");
        this.namespace = namespace;
        this.identifier = identifier;
        this.metadataType = metadataType;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public MetadataType getType() {
        return this.metadataType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableNotificationModel)) {
            return false;
        }
        ImmutableNotificationModel that = (ImmutableNotificationModel)o;
        return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.identifier, that.identifier) && Objects.equals(this.metadataType, that.metadataType);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.identifier, this.metadataType);
    }
}

