/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.math.RoundingMode;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.Aprational;
import org.apfloat.AprationalMath;
import org.apfloat.OverflowException;

class RoundingHelper {
    private RoundingHelper() {
    }

    public static Apfloat roundToMultiple(Apfloat x, Apfloat y, RoundingMode roundingMode) throws IllegalArgumentException, ArithmeticException, ApfloatRuntimeException {
        long precision;
        if (x.signum() == 0) {
            return x;
        }
        if (y.signum() == 0) {
            throw new ArithmeticException("Non-zero as multiple of zero");
        }
        int signum = x.signum();
        if ((x = RoundingHelper.roundToPrecision(ApfloatMath.abs(x), x.precision(), RoundingMode.UNNECESSARY)).compareTo(y = RoundingHelper.roundToPrecision(ApfloatMath.abs(y), y.precision(), RoundingMode.UNNECESSARY)) < 0) {
            precision = 20L;
        } else {
            long scaleDiff = x.scale() - y.scale();
            scaleDiff = scaleDiff < 0L ? Long.MAX_VALUE : scaleDiff;
            precision = ApfloatHelper.extendPrecision(scaleDiff);
        }
        Apfloat i = x.precision(precision).divide(y.precision(precision));
        Apint r = RoundingHelper.roundToInteger(i, RoundingMode.HALF_UP);
        Apint two = new Apint(2L, x.radix());
        if (r.multiply(y.precision(Long.MAX_VALUE)).equals(x.precision(Long.MAX_VALUE))) {
            i = r;
        } else {
            r = RoundingHelper.roundToInteger(i.multiply(two), RoundingMode.HALF_UP);
            if (r.multiply(y.precision(Long.MAX_VALUE)).equals(x.precision(Long.MAX_VALUE).multiply(two))) {
                i = new Aprational(r, two);
            }
        }
        i = signum < 0 ? i.negate() : i;
        i = RoundingHelper.roundToInteger(i, roundingMode);
        i = i.multiply(y);
        return i;
    }

    public static Aprational roundToMultiple(Aprational x, Aprational y, RoundingMode roundingMode) throws IllegalArgumentException, ArithmeticException, ApfloatRuntimeException {
        if (x.signum() == 0) {
            return x;
        }
        if (y.signum() == 0) {
            throw new ArithmeticException("Non-zero as multiple of zero");
        }
        y = AprationalMath.abs(y);
        Aprational i = RoundingHelper.roundToInteger(x.divide(y), roundingMode);
        i = i.multiply(y);
        return i;
    }

    public static Apfloat roundToPlaces(Apfloat x, long places, RoundingMode roundingMode) throws IllegalArgumentException, ArithmeticException, ApfloatRuntimeException {
        if (x.signum() == 0) {
            return x;
        }
        if ((x = x.scale(places)).signum() == 0) {
            throw new OverflowException("Underflow / overflow");
        }
        x = RoundingHelper.roundToInteger(x, roundingMode);
        if (places == Long.MIN_VALUE) {
            x = ApfloatMath.scale(x, 0x4000000000000000L);
            x = ApfloatMath.scale(x, 0x4000000000000000L);
        } else {
            x = ApfloatMath.scale(x, -places);
        }
        return x;
    }

    public static Apfloat roundToPrecision(Apfloat x, long precision, RoundingMode roundingMode) throws IllegalArgumentException, ArithmeticException, ApfloatRuntimeException {
        boolean overflow;
        if (precision <= 0L) {
            throw new IllegalArgumentException("Invalid precision: " + precision);
        }
        if (x.signum() == 0 || precision == Long.MAX_VALUE) {
            return x.precision(precision);
        }
        long targetPrecision = precision;
        precision = Math.min(precision, x.size());
        long scale = x.scale();
        boolean bl = overflow = scale - precision >= scale;
        if (overflow) {
            x = x.scale(-scale);
            x = x.scale(precision);
        } else {
            x = x.scale(precision - scale);
        }
        x = RoundingHelper.roundToInteger(x, roundingMode);
        if (overflow) {
            x = ApfloatMath.scale(x, -precision);
            x = ApfloatMath.scale(x, scale);
        } else {
            x = ApfloatMath.scale(x, scale - precision);
        }
        return x.precision(targetPrecision);
    }

    public static Apint roundToInteger(Apfloat x, RoundingMode roundingMode) throws IllegalArgumentException, ArithmeticException, ApfloatRuntimeException {
        Apint i;
        switch (roundingMode) {
            case UP: {
                i = x.roundAway();
                break;
            }
            case DOWN: {
                i = x.truncate();
                break;
            }
            case CEILING: {
                i = x.ceil();
                break;
            }
            case FLOOR: {
                i = x.floor();
                break;
            }
            case HALF_UP: 
            case HALF_DOWN: 
            case HALF_EVEN: {
                Apint whole = x.truncate();
                Apfloat fraction = x.frac().abs();
                int comparison = fraction.compareToHalf();
                if (comparison < 0 || comparison == 0 && roundingMode.equals((Object)RoundingMode.HALF_DOWN)) {
                    i = x.truncate();
                    break;
                }
                if (comparison > 0 || comparison == 0 && roundingMode.equals((Object)RoundingMode.HALF_UP)) {
                    i = x.roundAway();
                    break;
                }
                i = RoundingHelper.isEven(whole) ? x.truncate() : x.roundAway();
                break;
            }
            case UNNECESSARY: {
                if (x.size() > x.scale()) {
                    throw new ArithmeticException("Rounding necessary");
                }
                i = x.truncate();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown rounding mode: " + (Object)((Object)roundingMode));
            }
        }
        return i;
    }

    public static int compareToHalf(Apfloat x) {
        int comparison;
        if (x.radix() % 2 == 0) {
            comparison = x.compareTo(new Apfloat("0." + Character.forDigit(x.radix() / 2, x.radix()), Long.MAX_VALUE, x.radix()));
        } else {
            Apint one = new Apint(1L, x.radix());
            Apint two = new Apint(2L, x.radix());
            comparison = x.precision(Long.MAX_VALUE).multiply(two).compareTo(one);
        }
        return comparison;
    }

    public static int compareToHalf(Aprational x) {
        Aprational half = new Aprational(new Apint(1L, x.radix()), new Apint(2L, x.radix()));
        int comparison = x.compareTo(half);
        return comparison;
    }

    private static boolean isEven(Apint x) {
        Apint two = new Apint(2L, x.radix());
        return x.mod(two).signum() == 0;
    }
}

