/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.repository.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;

public class CachingStateRepository
implements StateRepository {
    private final StateRepository delegate;
    private final Map<String, CacheEntry> cache = new ConcurrentHashMap<String, CacheEntry>();
    private final long ttl;

    public CachingStateRepository(StateRepository delegate) {
        this(delegate, 0L);
    }

    public CachingStateRepository(StateRepository delegate, long ttl) {
        if (ttl < 0L) {
            throw new IllegalArgumentException("Negative TTL value: " + ttl);
        }
        this.delegate = delegate;
        this.ttl = ttl;
    }

    public CachingStateRepository(StateRepository delegate, long ttl, TimeUnit ttlTimeUnit) {
        this(delegate, ttlTimeUnit.toMillis(ttl));
    }

    @Override
    public FeatureState getFeatureState(Feature feature) {
        CacheEntry entry = this.cache.get(feature.name());
        if (this.isValidEntry(entry)) {
            return entry.getState();
        }
        return this.reloadFeatureState(feature);
    }

    private synchronized FeatureState reloadFeatureState(Feature feature) {
        CacheEntry cachedState = this.cache.get(feature.name());
        if (this.isValidEntry(cachedState)) {
            return cachedState.getState();
        }
        FeatureState featureState = this.delegate.getFeatureState(feature);
        this.storeFeatureState(feature, featureState);
        return featureState;
    }

    private void storeFeatureState(Feature feature, FeatureState featureState) {
        this.cache.put(feature.name(), new CacheEntry(featureState != null ? featureState.copy() : null, this.ttl));
    }

    private boolean isValidEntry(CacheEntry entry) {
        return entry != null && !entry.isExpired();
    }

    @Override
    public void setFeatureState(FeatureState featureState) {
        this.delegate.setFeatureState(featureState);
        this.cache.remove(featureState.getFeature().name());
    }

    public void clear() {
        this.cache.clear();
    }

    private static class CacheEntry {
        private final FeatureState state;
        private final long timestamp;
        private final long ttl;

        public CacheEntry(FeatureState state, long ttl) {
            this.state = state;
            this.timestamp = System.currentTimeMillis();
            this.ttl = ttl;
        }

        public FeatureState getState() {
            return this.state;
        }

        public boolean isExpired() {
            if (this.ttl == 0L) {
                return false;
            }
            return this.timestamp + this.ttl < System.currentTimeMillis();
        }
    }
}

