/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.manager;

import java.util.UUID;
import org.togglz.core.Feature;
import org.togglz.core.activation.ActivationStrategyProvider;
import org.togglz.core.activation.DefaultActivationStrategyProvider;
import org.togglz.core.manager.DefaultFeatureManager;
import org.togglz.core.manager.EnumBasedFeatureProvider;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.manager.TogglzConfig;
import org.togglz.core.repository.StateRepository;
import org.togglz.core.repository.mem.InMemoryStateRepository;
import org.togglz.core.spi.ActivationStrategy;
import org.togglz.core.spi.FeatureProvider;
import org.togglz.core.user.NoOpUserProvider;
import org.togglz.core.user.UserProvider;
import org.togglz.core.util.Validate;

public class FeatureManagerBuilder {
    private String name = null;
    private FeatureProvider featureProvider = null;
    private StateRepository stateRepository = null;
    private UserProvider userProvider = null;
    private ActivationStrategyProvider strategyProvider = null;

    public static FeatureManagerBuilder begin() {
        return new FeatureManagerBuilder();
    }

    public FeatureManagerBuilder stateRepository(StateRepository stateRepository) {
        this.stateRepository = stateRepository;
        return this;
    }

    public FeatureManagerBuilder featureEnum(Class<? extends Feature> featureEnum) {
        return this.featureEnums(featureEnum);
    }

    @SafeVarargs
    public final FeatureManagerBuilder featureEnums(Class<? extends Feature> ... featureEnum) {
        this.featureProvider = new EnumBasedFeatureProvider(featureEnum);
        this.name = "FeatureManager[" + featureEnum[0].getSimpleName() + "]";
        return this;
    }

    public FeatureManagerBuilder name(String name) {
        this.name = name;
        return this;
    }

    public FeatureManagerBuilder featureProvider(FeatureProvider featureProvider) {
        this.featureProvider = featureProvider;
        return this;
    }

    public FeatureManagerBuilder userProvider(UserProvider userProvider) {
        this.userProvider = userProvider;
        return this;
    }

    public FeatureManagerBuilder activationStrategyProvider(ActivationStrategyProvider strategyProvider) {
        this.strategyProvider = strategyProvider;
        return this;
    }

    public FeatureManagerBuilder activationStrategy(ActivationStrategy strategy) {
        if (strategy == null) {
            this.activationStrategyProvider(new DefaultActivationStrategyProvider());
        }
        if (this.strategyProvider instanceof DefaultActivationStrategyProvider) {
            ((DefaultActivationStrategyProvider)this.strategyProvider).addActivationStrategy(strategy);
            return this;
        }
        throw new IllegalStateException("Adding ActivationStrategies is only allowed when using " + DefaultActivationStrategyProvider.class.getSimpleName());
    }

    public FeatureManagerBuilder togglzConfig(TogglzConfig config) {
        this.stateRepository(config.getStateRepository());
        this.featureEnum(config.getFeatureClass());
        this.userProvider(config.getUserProvider());
        return this;
    }

    public FeatureManager build() {
        String name = this.name != null ? this.name : UUID.randomUUID().toString();
        FeatureProvider featureProvider = this.featureProvider;
        StateRepository stateRepository = this.stateRepository != null ? this.stateRepository : new InMemoryStateRepository();
        UserProvider userProvider = this.userProvider != null ? this.userProvider : new NoOpUserProvider();
        ActivationStrategyProvider strategyProvider = this.strategyProvider != null ? this.strategyProvider : new DefaultActivationStrategyProvider();
        Validate.notBlank(name, "No name specified");
        Validate.notNull(featureProvider, "No feature provider specified");
        return new DefaultFeatureManager(name, featureProvider, stateRepository, userProvider, strategyProvider);
    }
}

