/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.privileged.spring;

import net.bytebuddy.ByteBuddy;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import org.mule.runtime.config.privileged.spring.ByteBuddySpringCachesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.SpringVersion;
import org.springframework.util.ConcurrentReferenceHashMap;

public class ByteBuddySpringCacheInstrumentator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ByteBuddySpringCacheInstrumentator.class);
    private static final String CONCURRENT_REFERENCE_HASH_MAP_CLASS = "org.springframework.util.ConcurrentReferenceHashMap";
    private static final ByteBuddy BYTE_BUDDY = new ByteBuddy();
    public static final ClassFileLocator BOOT_LOADER = ClassFileLocator.ForClassLoader.ofBootLoader();

    public static void instrumentSpringCachesForCleanup() {
        try {
            ClassLoader targetClassloader = SpringVersion.class.getClassLoader();
            ClassFileLocator.Compound classFileLocator = new ClassFileLocator.Compound(new ClassFileLocator[]{ClassFileLocator.ForClassLoader.of((ClassLoader)targetClassloader), BOOT_LOADER});
            TypePool targetTypePool = TypePool.Default.of((ClassFileLocator)classFileLocator);
            try {
                targetClassloader.loadClass(ByteBuddySpringCachesManager.class.getName());
            }
            catch (ClassNotFoundException e) {
                try (DynamicType.Unloaded unloaded = BYTE_BUDDY.decorate(ByteBuddySpringCachesManager.class).make();){
                    unloaded.load(targetClassloader, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION);
                }
            }
            try (DynamicType.Unloaded unloaded = BYTE_BUDDY.rebase(targetTypePool.describe(CONCURRENT_REFERENCE_HASH_MAP_CLASS).resolve(), (ClassFileLocator)classFileLocator).visit((AsmVisitorWrapper)Advice.to(ByteBuddySpringCachesManager.class).on((ElementMatcher)ElementMatchers.isConstructor())).make();){
                unloaded.load(targetClassloader, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION);
            }
            LOGGER.debug("Spring caches are now instrumented for cleanup.");
        }
        catch (Exception e) {
            LOGGER.error("Could not instrument Spring caches for cleanup.", (Throwable)e);
        }
    }

    public static void instrumentSpringCachesForWeakReferences() {
        ClassLoader targetClassloader = SpringVersion.class.getClassLoader();
        TypePool typePool = TypePool.Default.of((ClassLoader)targetClassloader);
        try (DynamicType.Unloaded unloaded = BYTE_BUDDY.redefine(typePool.describe(CONCURRENT_REFERENCE_HASH_MAP_CLASS).resolve(), ClassFileLocator.ForClassLoader.of((ClassLoader)targetClassloader)).constructor(target -> target.isConstructor() && target.getParameters().size() < 4).intercept((Implementation)MethodCall.invoke(target -> target.isConstructor() && target.getParameters().size() == 4).with(new Object[]{16, Float.valueOf(0.75f), 16, ConcurrentReferenceHashMap.ReferenceType.WEAK})).make();){
            unloaded.load(targetClassloader, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION);
            LOGGER.debug("Spring caches are now instrumented for using weak keys.");
        }
        catch (Exception e) {
            LOGGER.error("Could not instrument Spring caches for using weak keys.", (Throwable)e);
        }
    }
}

