/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.config.internal.context.ObjectProviderAwareBeanFactory;
import org.mule.runtime.config.internal.factories.ConstantFactoryBean;
import org.mule.runtime.config.internal.registry.BeanDependencyResolver;
import org.mule.runtime.config.internal.registry.ReadOnlyRegistrationDelegate;
import org.mule.runtime.config.internal.registry.RegistrationDelegate;
import org.mule.runtime.config.internal.registry.SpringContextRegistry;
import org.mule.runtime.config.internal.registry.SpringRegistryLifecycleManager;
import org.mule.runtime.config.internal.resolvers.ConfigurationDependencyResolver;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleManager;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.internal.lifecycle.LifecycleInterceptor;
import org.mule.runtime.core.internal.registry.AbstractRegistry;
import org.mule.runtime.core.internal.util.InjectionUtils;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

public abstract class AbstractSpringRegistry
extends AbstractRegistry
implements SpringContextRegistry,
Injector {
    public static final String REGISTRY_ID = "org.mule.Registry.Spring";
    public static final String SPRING_APPLICATION_CONTEXT = "springApplicationContext";
    private static final String COULD_NOT_ADD_ENTRY_REGISTRY_HAS_BEEN_STOPPED = "Could not add entry with key '%s': Registry has been stopped.";
    private ApplicationContext applicationContext;
    private RegistrationDelegate registrationDelegate;
    private boolean readOnly;
    private final AtomicBoolean isStopped = new AtomicBoolean(false);
    protected AtomicBoolean springContextInitialised = new AtomicBoolean(false);
    protected final Map<String, BeanDefinition> registeredBeanDefinitionsBeforeInitialization = new HashMap<String, BeanDefinition>();

    public AbstractSpringRegistry(ApplicationContext applicationContext, MuleContext muleContext, LifecycleInterceptor lifecycleInterceptor) {
        super(REGISTRY_ID, muleContext, lifecycleInterceptor);
        this.setApplicationContext(applicationContext);
    }

    protected void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.readOnly = false;
            this.registrationDelegate = new ConfigurableRegistrationDelegate((ConfigurableApplicationContext)applicationContext);
        } else {
            this.readOnly = true;
            this.registrationDelegate = new ReadOnlyRegistrationDelegate();
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected void addBeanFactoryPostProcessor(BeanDefinitionRegistryPostProcessor postProcessor) {
        ((AbstractApplicationContext)this.applicationContext).addBeanFactoryPostProcessor((BeanFactoryPostProcessor)postProcessor);
    }

    protected void doInitialise() throws InitialisationException {
        if (!this.isReadOnly()) {
            ((ConfigurableApplicationContext)this.applicationContext).refresh();
        }
    }

    public void doDispose() {
        if (!this.springContextInitialised.get()) {
            return;
        }
        if (!this.isReadOnly() && ((ConfigurableApplicationContext)this.applicationContext).isActive()) {
            ((ConfigurableApplicationContext)this.applicationContext).close();
        }
        this.applicationContext = null;
        this.disposeContext();
        this.springContextInitialised.set(false);
    }

    protected void disposeContext() {
    }

    protected LifecycleManager createLifecycleManager(LifecycleInterceptor lifecycleInterceptor) {
        return new SpringRegistryLifecycleManager(this.getRegistryId(), this, this.getMuleContext(), lifecycleInterceptor);
    }

    public <T> T lookupObject(String key) {
        try {
            return (T)this.lookupObject(key, true);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public Object lookupObject(String key, boolean applyLifecycle) {
        Object object;
        if (StringUtils.isBlank((String)key)) {
            this.logger.warn(I18nMessageFactory.createStaticMessage((String)"Detected a lookup attempt with an empty or null key").getMessage(), new Throwable().fillInStackTrace());
            return null;
        }
        if (key.equals(SPRING_APPLICATION_CONTEXT) && this.applicationContext != null) {
            return this.applicationContext;
        }
        try {
            object = this.applicationContext.getBean(key);
        }
        catch (NoSuchBeanDefinitionException e) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(e.getMessage(), (Throwable)e);
            } else {
                this.logger.debug(e.getMessage());
            }
            return null;
        }
        if (this.isNullBean(object)) {
            return null;
        }
        this.applyLifecycleIfPrototype(object, key, applyLifecycle);
        return object;
    }

    protected final boolean isNullBean(Object bean) {
        return bean != null && "org.springframework.beans.factory.support.NullBean".equals(bean.getClass().getName());
    }

    protected final void applyLifecycleIfPrototype(Object object, String key, boolean applyLifecycle) {
        if (applyLifecycle && !this.isSingleton(key)) {
            try {
                this.getLifecycleManager().applyCompletedPhases(object);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not apply lifecycle into prototype object " + key)), (Throwable)e);
            }
        }
    }

    public <T> Collection<T> lookupObjects(Class<T> type) {
        return this.lookupByType(type).values();
    }

    public <T> Collection<T> lookupLocalObjects(Class<T> type) {
        return this.internalLookupByTypeWithoutAncestorsAndObjectProviders(type, true, true).values();
    }

    public <T> Collection<T> lookupObjectsForLifecycle(Class<T> type) {
        return this.lookupEntriesForLifecycle(type).values();
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.internalLookupByType(type, true, true);
    }

    public boolean isSingleton(String key) {
        return this.applicationContext.isSingleton(key);
    }

    public void registerObject(String key, Object value) throws RegistrationException {
        this.registrationDelegate.registerObject(key, value);
    }

    public void registerObject(String key, Object value, Object metadata) throws RegistrationException {
        this.registrationDelegate.registerObject(key, value, metadata);
    }

    public void registerObjects(Map<String, Object> objects) throws RegistrationException {
        this.registrationDelegate.registerObjects(objects);
    }

    protected Object doUnregisterObject(String key) throws RegistrationException {
        return this.registrationDelegate.unregisterObject(key);
    }

    public <T> T inject(T object) {
        object = InjectionUtils.getInjectionTarget(object);
        try {
            return this.initialiseObject((ConfigurableApplicationContext)this.applicationContext, "", object);
        }
        catch (LifecycleException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)new LifecycleException((Throwable)e, object));
        }
    }

    public Object applyLifecycle(Object object) throws MuleException {
        LifecycleManager lifecycleManager = this.getLifecycleManager();
        lifecycleManager.applyCompletedPhases(object);
        if (lifecycleManager.getExecutingPhase() != null) {
            lifecycleManager.applyPhase(object, lifecycleManager.getCurrentPhase(), lifecycleManager.getExecutingPhase());
        }
        return object;
    }

    public Object applyLifecycle(Object object, String phase) throws MuleException {
        if (phase == null) {
            this.getLifecycleManager().applyCompletedPhases(object);
        } else {
            this.getLifecycleManager().applyPhase(object, "not in lifecycle", phase);
        }
        return object;
    }

    public void applyLifecycle(Object object, String startPhase, String toPhase) throws MuleException {
        this.getLifecycleManager().applyPhase(object, startPhase, toPhase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fireLifecycle(String phase) throws LifecycleException {
        AtomicBoolean atomicBoolean = this.isStopped;
        synchronized (atomicBoolean) {
            this.isStopped.set("stop".equals(phase) || "dispose".equals(phase));
        }
        super.fireLifecycle(phase);
    }

    protected final <T> T initialiseObject(ConfigurableApplicationContext applicationContext, String key, T object) throws LifecycleException {
        applicationContext.getBeanFactory().autowireBean(object);
        return (T)applicationContext.getBeanFactory().initializeBean(object, key);
    }

    protected <T> Map<String, T> internalLookupByType(Class<T> type, boolean nonSingletons, boolean eagerInit) {
        try {
            Map beans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, type, (boolean)nonSingletons, (boolean)eagerInit);
            if (nonSingletons && eagerInit) {
                beans.forEach((key, value) -> this.applyLifecycleIfPrototype(value, (String)key, true));
            }
            return beans;
        }
        catch (FatalBeanException fbex) {
            String message = String.format("Failed to lookup beans of type %s from the Spring registry", type);
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)message), (Throwable)fbex);
        }
        catch (Exception e) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(e.getMessage(), (Throwable)e);
            } else {
                this.logger.debug(e.getMessage());
            }
            return Collections.emptyMap();
        }
    }

    protected abstract <T> Map<String, T> lookupEntriesForLifecycleIncludingAncestors(Class<T> var1);

    protected <T> Map<String, T> internalLookupByTypeWithoutAncestorsAndObjectProviders(Class<T> type, boolean nonSingletons, boolean eagerInit) {
        return this.internalLookupByTypeWithoutAncestorsAndObjectProviders(type, nonSingletons, eagerInit, this.applicationContext);
    }

    protected final <T> Map<String, T> internalLookupByTypeWithoutAncestorsAndObjectProviders(Class<T> type, boolean nonSingletons, boolean eagerInit, ApplicationContext applicationCtx) {
        try {
            Map<String, T> beans = ((ObjectProviderAwareBeanFactory)applicationCtx.getAutowireCapableBeanFactory()).getBeansOfTypeWithObjectProviderObjects(type, nonSingletons, eagerInit);
            if (nonSingletons && eagerInit) {
                beans.forEach((key, value) -> this.applyLifecycleIfPrototype(value, (String)key, true));
            }
            return beans;
        }
        catch (FatalBeanException fbex) {
            String message = String.format("Failed to lookup beans of type %s from the Spring registry", type);
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)message), (Throwable)fbex);
        }
        catch (Exception e) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(e.getMessage(), (Throwable)e);
            } else {
                this.logger.debug(e.getMessage());
            }
            return Collections.emptyMap();
        }
    }

    <T> Map<String, T> lookupEntriesForLifecycle(Class<T> type) {
        return this.internalLookupByTypeWithoutAncestorsAndObjectProviders(type, false, false, this.applicationContext);
    }

    @Override
    public Map<String, Object> getDependencies(String key) {
        if (!this.readOnly) {
            HashMap<String, Object> dependents = new HashMap<String, Object>();
            for (String dependentKey : ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory().getDependenciesForBean(key)) {
                boolean isBeanDefinition = ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory().containsBeanDefinition(dependentKey);
                if (!isBeanDefinition || !this.applicationContext.isSingleton(dependentKey)) continue;
                dependents.put(dependentKey, this.get(dependentKey));
            }
            return dependents;
        }
        throw new UnsupportedOperationException("This operation is only available when this registry is backed by a ConfigurableApplicationContext");
    }

    public abstract BeanDependencyResolver getBeanDependencyResolver();

    public abstract ConfigurationDependencyResolver getConfigurationDependencyResolver();

    @Override
    public String[] getBeanNamesForType(Class<?> type) {
        return this.applicationContext.getBeanNamesForType(type);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isRemote() {
        return false;
    }

    private class ConfigurableRegistrationDelegate
    implements RegistrationDelegate {
        private final ConfigurableApplicationContext applicationContext;

        private ConfigurableRegistrationDelegate(ConfigurableApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerObject(String key, Object value) throws RegistrationException {
            try {
                AtomicBoolean atomicBoolean = AbstractSpringRegistry.this.isStopped;
                synchronized (atomicBoolean) {
                    if (AbstractSpringRegistry.this.isStopped.get()) {
                        throw new RegistrationException(I18nMessageFactory.createStaticMessage((String)String.format(AbstractSpringRegistry.COULD_NOT_ADD_ENTRY_REGISTRY_HAS_BEEN_STOPPED, key)));
                    }
                    this.doRegisterObject(key, value);
                }
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RegistrationException) {
                    throw (RegistrationException)cause;
                }
                throw new RegistrationException(cause);
            }
        }

        @Override
        public void registerObject(String key, Object value, Object metadata) throws RegistrationException {
            this.registerObject(key, value);
        }

        @Override
        public void registerObjects(Map<String, Object> objects) throws RegistrationException {
            if (objects == null || objects.isEmpty()) {
                return;
            }
            for (Map.Entry<String, Object> entry : objects.entrySet()) {
                this.registerObject(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object unregisterObject(String key) throws RegistrationException {
            Object object;
            try {
                object = this.applicationContext.getBean(key);
            }
            catch (BeanCreationException e) {
                object = null;
            }
            if (this.applicationContext.getBeanFactory().containsBeanDefinition(key)) {
                ((BeanDefinitionRegistry)this.applicationContext.getBeanFactory()).removeBeanDefinition(key);
            }
            ((DefaultListableBeanFactory)this.applicationContext.getBeanFactory()).destroySingleton(key);
            return object;
        }

        private void doRegisterObject(String key, Object value) throws RegistrationException {
            if (AbstractSpringRegistry.this.springContextInitialised.get()) {
                if (this.applicationContext.containsBean(key)) {
                    if (AbstractSpringRegistry.this.logger.isWarnEnabled()) {
                        AbstractSpringRegistry.this.logger.warn(String.format("Spring registry already contains an object named '%s'. The previous object will be overwritten.", key));
                    }
                    AbstractSpringRegistry.this.unregisterObject(key);
                }
                try {
                    value = AbstractSpringRegistry.this.initialiseObject(this.applicationContext, key, value);
                    AbstractSpringRegistry.this.applyLifecycle(value);
                    this.applicationContext.getBeanFactory().registerSingleton(key, value);
                }
                catch (Exception e) {
                    throw new RegistrationException(I18nMessageFactory.createStaticMessage((String)("Could not register object for key " + key)), (Throwable)e);
                }
            } else {
                AbstractSpringRegistry.this.registeredBeanDefinitionsBeforeInitialization.put(key, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(ConstantFactoryBean.class).addConstructorArgValue(value).getBeanDefinition());
            }
        }
    }
}

