/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.log;

import org.slf4j.Logger;

public class OneTimeWarning {
    private final Logger logger;
    private final String message;
    private boolean warned = false;
    private Delegate delegate = new FirstTimeDelegate();

    public OneTimeWarning(Logger logger, String message) {
        this.logger = logger;
        this.message = message;
    }

    public void warn() {
        this.delegate.warn();
    }

    public void warn(Object ... args) {
        this.delegate.warn(args);
    }

    private class FirstTimeDelegate
    implements Delegate {
        private FirstTimeDelegate() {
        }

        @Override
        public synchronized void warn() {
            this.warn(null);
        }

        @Override
        public synchronized void warn(Object ... args) {
            if (!OneTimeWarning.this.warned) {
                if (args != null) {
                    OneTimeWarning.this.logger.warn(OneTimeWarning.this.message, args);
                } else {
                    OneTimeWarning.this.logger.warn(OneTimeWarning.this.message);
                }
                OneTimeWarning.this.warned = true;
                OneTimeWarning.this.delegate = new NoOpDelegate();
            }
        }
    }

    private static interface Delegate {
        public void warn();

        public void warn(Object ... var1);
    }

    private class NoOpDelegate
    implements Delegate {
        private NoOpDelegate() {
        }

        @Override
        public void warn() {
        }

        @Override
        public void warn(Object ... args) {
        }
    }
}

