/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.registry.TransformerResolver;
import org.mule.runtime.core.internal.registry.TypeBasedTransformerResolver;
import org.mule.runtime.core.internal.transformer.ResolverException;
import org.mule.runtime.core.internal.transformer.TransformersRegistry;

public class DefaultTransformersRegistry
implements TransformersRegistry,
Initialisable,
Disposable {
    @Inject
    private MuleContext muleContext;
    private final Map<String, Transformer> exactTransformerCache = new ConcurrentHashMap<String, Transformer>(8);
    private final Map<String, List<Transformer>> transformerListCache = new ConcurrentHashMap<String, List<Transformer>>(8);
    private List<TransformerResolver> transformerResolvers = Collections.emptyList();
    private Collection<Transformer> transformers = Collections.emptyList();

    public void initialise() throws InitialisationException {
        this.transformers.stream().filter(t -> t instanceof Converter).forEach(t -> this.notifyTransformerResolvers((Transformer)t));
        Collections.sort(this.transformerResolvers, new TransformerResolverComparator());
        this.clearCaches();
    }

    public void dispose() {
        this.clearCaches();
    }

    @Override
    public Transformer lookupTransformer(DataType source, DataType result) throws TransformerException {
        String dataTypePairHash = this.getDataTypeSourceResultPairHash(source, result = DataType.builder((DataType)result).mediaType(MediaType.ANY).charset((Charset)null).build());
        Transformer cachedTransformer = this.exactTransformerCache.get(dataTypePairHash);
        if (cachedTransformer != null) {
            return cachedTransformer;
        }
        Transformer trans = this.resolveTransformer(source, result);
        if (trans != null) {
            Transformer concurrentlyAddedTransformer = this.exactTransformerCache.putIfAbsent(dataTypePairHash, trans);
            if (concurrentlyAddedTransformer != null) {
                return concurrentlyAddedTransformer;
            }
            return trans;
        }
        throw new TransformerException(CoreMessages.noTransformerFoundForMessage(source, result));
    }

    private Transformer resolveTransformer(DataType source, DataType result) throws TransformerException {
        for (TransformerResolver resolver : this.transformerResolvers) {
            try {
                Transformer trans = resolver.resolve(source, result);
                if (trans == null) continue;
                return trans;
            }
            catch (ResolverException e) {
                throw new TransformerException(CoreMessages.noTransformerFoundForMessage(source, result), (Throwable)((Object)e));
            }
        }
        return null;
    }

    @Override
    public List<Transformer> lookupTransformers(DataType source, DataType result) {
        String dataTypePairHash = this.getDataTypeSourceResultPairHash(source, result = DataType.builder((DataType)result).mediaType(MediaType.ANY).charset((Charset)null).build());
        List<Transformer> results = this.transformerListCache.get(dataTypePairHash);
        if (results != null) {
            return results;
        }
        results = new ArrayList<Transformer>(2);
        for (Transformer transformer : this.transformers) {
            if (!(transformer instanceof Converter) || !result.isCompatibleWith(transformer.getReturnDataType()) || !transformer.isSourceDataTypeSupported(source)) continue;
            results.add(transformer);
        }
        List<Transformer> concurrentlyAddedTransformers = this.transformerListCache.putIfAbsent(dataTypePairHash, results);
        if (concurrentlyAddedTransformers != null) {
            return concurrentlyAddedTransformers;
        }
        return results;
    }

    @Override
    public void registerTransformer(Transformer transformer) throws MuleException {
        LifecycleUtils.initialiseIfNeeded(transformer, this.muleContext);
        if (transformer instanceof Converter) {
            this.notifyTransformerResolvers(transformer);
        }
        this.clearCaches();
    }

    protected void clearCaches() {
        this.transformerListCache.clear();
        this.exactTransformerCache.clear();
    }

    public void notifyTransformerResolvers(Transformer t) {
        if (t instanceof Converter) {
            for (TransformerResolver resolver : this.transformerResolvers) {
                resolver.transformerChange(t, TransformerResolver.RegistryAction.ADDED);
            }
        }
    }

    private String getDataTypeSourceResultPairHash(DataType source, DataType result) {
        return source.getClass().getName() + source.hashCode() + ":" + result.getClass().getName() + result.hashCode();
    }

    @Inject
    public void setTransformerResolvers(List<TransformerResolver> transformerResolvers) {
        this.transformerResolvers = transformerResolvers;
    }

    @Inject
    public void setTransformers(Collection<Transformer> transformers) {
        this.transformers = transformers;
    }

    private class TransformerResolverComparator
    implements Comparator<TransformerResolver> {
        private TransformerResolverComparator() {
        }

        @Override
        public int compare(TransformerResolver transformerResolver, TransformerResolver transformerResolver1) {
            if (transformerResolver.getClass().equals(TypeBasedTransformerResolver.class)) {
                return 1;
            }
            if (transformerResolver1.getClass().equals(TypeBasedTransformerResolver.class)) {
                return -1;
            }
            return 0;
        }
    }
}

