/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.jar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import org.apache.commons.io.IOUtils;

public class JarLoadingUtils {
    private JarLoadingUtils() {
    }

    public static JarURLConnection getJarConnection(URL possibleUrl) throws MalformedURLException, IOException {
        return (JarURLConnection)possibleUrl.openConnection();
    }

    public static Optional<byte[]> loadFileContentFrom(File jarFile, String filePath) throws IOException {
        Optional<byte[]> optional;
        block8: {
            URL jsonDescriptorUrl = JarLoadingUtils.getUrlWithinJar(jarFile, filePath);
            JarURLConnection jarConnection = (JarURLConnection)jsonDescriptorUrl.openConnection();
            jarConnection.setUseCaches(false);
            InputStream inputStream = jarConnection.getInputStream();
            try {
                byte[] byteArray = IOUtils.toByteArray((InputStream)inputStream);
                optional = Optional.of(byteArray);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    return Optional.empty();
                }
            }
            inputStream.close();
        }
        return optional;
    }

    public static Optional<byte[]> loadFileContentFrom(URL jarFile) throws IOException {
        Optional<byte[]> optional;
        block8: {
            JarURLConnection jarConnection = (JarURLConnection)jarFile.openConnection();
            jarConnection.setUseCaches(false);
            InputStream inputStream = jarConnection.getInputStream();
            try {
                byte[] byteArray = IOUtils.toByteArray((InputStream)inputStream);
                optional = Optional.of(byteArray);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    return Optional.empty();
                }
            }
            inputStream.close();
        }
        return optional;
    }

    public static URL getUrlWithinJar(File jarFile, String filePath) throws MalformedURLException {
        return new URL("jar:" + jarFile.toURI() + "!/" + filePath);
    }
}

